//! This is a documentation-only module with several sub-modules describing how to use
//! this crate.
//!
//! Table of contents:
//!  - [Introduction to BDDs](./p01_bdd_intro/index.html)
//!  - [Creating a `BddVariableSet` and `BddVariable`-s](./p02_bdd_variable_set/index.html)
//!  - [Manipulating `Bdd`s idiomatically](./p03_bdd_manipulation/index.html)
//!  - [Serialising and visualising `Bdd`s](./p04_bdd_serialisation/index.html)
//!  - [Working with BDD valuations and clauses](./p05_bdd_valuations/index.html)
//!  - [Advanced BDD operations](./p06_bdd_advanced_operations/index.html)
//!

pub mod p01_bdd_intro;
pub mod p02_bdd_variable_set;
pub mod p03_bdd_manipulation;
pub mod p04_bdd_serialisation;
pub mod p05_bdd_valuations;
pub mod p06_bdd_advanced_operations;
