# Examples

This document was generated by `cargo run --example all >examples.md`.

## Primitives

```rust
fn primitives() {
    binspect!(false);
    binspect!(true);
    binspect!(42);
    binspect!(- 42);
    binspect!(127u8);
    binspect!(0xabcd_u16);
    binspect!(0xefbeadde_u32);
    binspect!(5000_0000_0000_0000_u64);
    binspect!('A');
    binspect!('あ');
    binspect!('😇');
    binspect!(0.25f32);
    binspect!(0.1);
}
```

```text
-----+ 0x555f343bf630: bool = false
0000 | 00
-----+ 0x555f343bf645: bool = true
0000 | 01
-----+ 0x555f343bef78: i32 = 42
0000 | 2a 00 00 00
-----+ 0x555f343bef7c: i32 = -42
0000 | d6 ff ff ff
-----+ 0x555f343bf64b: u8 = 127u8
0000 | 7f
-----+ 0x555f343bf652: u16 = 0xabcd_u16
0000 | cd ab
-----+ 0x555f343bef80: u32 = 0xefbeadde_u32
0000 | de ad be ef
-----+ 0x555f343bf5e8: u64 = 5000_0000_0000_0000_u64
0000 | 00 80 e0 37 79 c3 11 00
-----+ 0x555f343bef84: char = 'A'
0000 | 41 00 00 00
-----+ 0x555f343bef88: char = 'あ'
0000 | 42 30 00 00
-----+ 0x555f343bef8c: char = '😇'
0000 | 07 f6 01 00
-----+ 0x555f343bef90: f32 = 0.25f32
0000 | 00 00 80 3e
-----+ 0x555f343bf5f0: f64 = 0.1
0000 | 9a 99 99 99 99 99 b9 3f
```

## Arrays

```rust
fn arrays() {
    binspect!([true, false, false, true]);
    binspect!([0xadde_u16, 0xefbe]);
    binspect!(b"\xde\xad\xbe\xef");
    binspect!(* b"\xde\xad\xbe\xef");
    binspect!([0_u64 ; 0]);
    binspect!([[1_i8, 2, 3], [4, 5, 6], [7, 8, 9]]);
}
```

```text
-----+ 0x555f343bef94: [bool; 4] = [true, false, false, true]
0000 | 01 00 00 01
-----+ 0x555f343bef80: [u16; 2] = [0xadde_u16, 0xefbe]
0000 | de ad be ef
-----+ 0x555f343ce400: &[u8; 4] = b"\xde\xad\xbe\xef"
0000 | 80 ef 3b 34 5f 55 00 00
-----+ 0x555f343bef80: [u8; 4] = *b"\xde\xad\xbe\xef"
0000 | de ad be ef
-----+ 0x555f343be130: [u64; 0] = [0_u64; 0]
-----+ 0x555f343bf6fa: [[i8; 3]; 3] = [[1_i8, 2, 3], [4, 5, 6], [7, 8, 9]]
0000 | 01 02 03 04 05 06 07 08 : 09
```

## Tuples

```rust
fn tuples() {
    binspect!(());
    binspect!((0xefbeadde_u32));
    binspect!((0x1111111111111111_u64, 0x22222222_u32, 0x_3333u16, 0x44_u8));
    binspect!((0x11_u8, 0x2222_u16, 0x33_u8));
    binspect!(((), (0xefbeadde_u32), (0x11_u8, 0x2222_u16, 0x33_u8)));
}
```

```text
-----+ 0x555f343be130: () = ()
-----+ 0x555f343bef80: u32 = (0xefbeadde_u32)
0000 | de ad be ef
-----+ 0x555f343be0e0: (u64, u32, u16, u8) = (0x1111111111111111_u64, 0x22222222_u32, 0x_3333u16, 0x44_u8)
0000 | 11 11 11 11 11 11 11 11 : 22 22 22 22 33 33 44 00
-----+ 0x555f343bef98: (u8, u16, u8) = (0x11_u8, 0x2222_u16, 0x33_u8)
0000 | 22 22 11 33
-----+ 0x555f343bf5f8: ((), u32, (u8, u16, u8)) = ((), (0xefbeadde_u32), (0x11_u8, 0x2222_u16, 0x33_u8))
0000 | de ad be ef 22 22 11 33
```

## Structs

```rust
struct S1; struct S2 {
    x: u32,
}
struct S3 {
    x: u64,
    y: u32,
    z: u16,
    w: u8,
}
struct S4 {
    x: u8,
    y: u16,
    z: u8,
}
struct S5 {
    s1: S1,
    s2: S2,
    s4: S4,
}
fn structs() {
    binspect!(S1 { });
    binspect!(S2 { x : 0xefbeadde_u32 });
    binspect!(S3
              {
                  x : 0x1111111111111111_u64, y : 0x22222222_u32, z :
                  0x_3333u16, w : 0x44_u8
              });
    binspect!(S4 { x : 0x11_u8, y : 0x2222_u16, z : 0x33_u8 });
    binspect!(S5
              {
                  s1 : S1 { }, s2 : S2 { x : 0xefbeadde_u32 }, s4 : S4
                  { x : 0x11_u8, y : 0x2222_u16, z : 0x33_u8 }
              });
}
```

```text
-----+ 0x555f343be130: all::S1 = S1{}
-----+ 0x555f343bef80: all::S2 = S2{x: 0xefbeadde_u32,}
0000 | de ad be ef
-----+ 0x555f343be0e0: all::S3 = S3{x: 0x1111111111111111_u64, y: 0x22222222_u32, z: 0x_3333u16, w: 0x44_u8,}
0000 | 11 11 11 11 11 11 11 11 : 22 22 22 22 33 33 44 00
-----+ 0x555f343bef98: all::S4 = S4{x: 0x11_u8, y: 0x2222_u16, z: 0x33_u8,}
0000 | 22 22 11 33
-----+ 0x555f343bf5f8: all::S5 = S5{s1: S1{},
   s2: S2{x: 0xefbeadde_u32,},
   s4: S4{x: 0x11_u8, y: 0x2222_u16, z: 0x33_u8,},}
0000 | de ad be ef 22 22 11 33
```

## Packed Structs

```rust
#[repr(packed)]
struct PS1; #[repr(packed)]
struct PS2 {
    x: u32,
}
#[repr(packed)]
struct PS3 {
    x: u64,
    y: u32,
    z: u16,
    w: u8,
}
#[repr(packed)]
struct PS4 {
    x: u8,
    y: u16,
    z: u8,
}
#[repr(packed)]
struct PS5 {
    s1: PS1,
    s2: PS2,
    s4: PS4,
}
fn packed_structs() {
    binspect!(PS1 { });
    binspect!(PS2 { x : 0xefbeadde_u32 });
    binspect!(PS3
              {
                  x : 0x1111111111111111_u64, y : 0x22222222_u32, z :
                  0x_3333u16, w : 0x44_u8
              });
    binspect!(PS4 { x : 0x11_u8, y : 0x2222_u16, z : 0x33_u8 });
    binspect!(PS5
              {
                  s1 : PS1 { }, s2 : PS2 { x : 0xefbeadde_u32 }, s4 : PS4
                  { x : 0x11_u8, y : 0x2222_u16, z : 0x33_u8 }
              });
}
```

```text
-----+ 0x555f343be130: all::PS1 = PS1{}
-----+ 0x555f343bef80: all::PS2 = PS2{x: 0xefbeadde_u32,}
0000 | de ad be ef
-----+ 0x555f343bf8c1: all::PS3 = PS3{x: 0x1111111111111111_u64, y: 0x22222222_u32, z: 0x_3333u16, w: 0x44_u8,}
0000 | 11 11 11 11 11 11 11 11 : 22 22 22 22 33 33 44
-----+ 0x555f343befa0: all::PS4 = PS4{x: 0x11_u8, y: 0x2222_u16, z: 0x33_u8,}
0000 | 11 22 22 33
-----+ 0x555f343bf600: all::PS5 = PS5{s1: PS1{},
    s2: PS2{x: 0xefbeadde_u32,},
    s4: PS4{x: 0x11_u8, y: 0x2222_u16, z: 0x33_u8,},}
0000 | de ad be ef 11 22 22 33
```

## C Structs

```rust
#[repr(C)]
struct CS1; #[repr(C)]
struct CS2 {
    x: u32,
}
#[repr(C)]
struct CS3 {
    x: u64,
    y: u32,
    z: u16,
    w: u8,
}
#[repr(C)]
struct CS4 {
    x: u8,
    y: u16,
    z: u8,
}
#[repr(C)]
struct CS5 {
    s1: CS1,
    s2: CS2,
    s4: CS4,
}
fn c_structs() {
    binspect!(CS1 { });
    binspect!(CS2 { x : 0xefbeadde_u32 });
    binspect!(CS3
              {
                  x : 0x1111111111111111_u64, y : 0x22222222_u32, z :
                  0x_3333u16, w : 0x44_u8
              });
    binspect!(CS4 { x : 0x11_u8, y : 0x2222_u16, z : 0x33_u8 });
    binspect!(CS5
              {
                  s1 : CS1 { }, s2 : CS2 { x : 0xefbeadde_u32 }, s4 : CS4
                  { x : 0x11_u8, y : 0x2222_u16, z : 0x33_u8 }
              });
}
```

```text
-----+ 0x555f343be130: all::CS1 = CS1{}
-----+ 0x555f343bef80: all::CS2 = CS2{x: 0xefbeadde_u32,}
0000 | de ad be ef
-----+ 0x555f343be0e0: all::CS3 = CS3{x: 0x1111111111111111_u64, y: 0x22222222_u32, z: 0x_3333u16, w: 0x44_u8,}
0000 | 11 11 11 11 11 11 11 11 : 22 22 22 22 33 33 44 00
-----+ 0x555f343bfa16: all::CS4 = CS4{x: 0x11_u8, y: 0x2222_u16, z: 0x33_u8,}
0000 | 11 00 22 22 33 00
-----+ 0x555f343bfa48: all::CS5 = CS5{s1: CS1{},
    s2: CS2{x: 0xefbeadde_u32,},
    s4: CS4{x: 0x11_u8, y: 0x2222_u16, z: 0x33_u8,},}
0000 | de ad be ef 11 00 22 22 : 33 00 00 00
```

## Enums

```rust
enum E1 { V1, V2, V3, } enum E2 { V1(u32), V2(u8, u16, u8), V3, }
fn enums() {
    binspect!(E1 :: V1);
    binspect!(E1 :: V2);
    binspect!(E1 :: V3);
    binspect!(E2 :: V1(0xefbeadde));
    binspect!(E2 :: V2(0x11, 0x2222, 0x33));
    binspect!(E2 :: V3);
}
```

```text
-----+ 0x555f343bf630: all::E1 = E1::V1
0000 | 00
-----+ 0x555f343bf645: all::E1 = E1::V2
0000 | 01
-----+ 0x555f343bfac5: all::E1 = E1::V3
0000 | 02
-----+ 0x555f343bf608: all::E2 = E2::V1(0xefbeadde)
0000 | 00 00 00 00 de ad be ef
-----+ 0x555f343bf610: all::E2 = E2::V2(0x11, 0x2222, 0x33)
0000 | 01 11 33 00 22 22 00 00
-----+ 0x555f343bf618: all::E2 = E2::V3
0000 | 02 00 00 00 00 00 00 00
```

## Slices

```rust
fn slices() {
    let bs = &[0xadde_u16, 0xefbe];
    binspect!(bs);
    binspect!(* bs);
}
```

```text
-----+ 0x7ffe4d2f6fa0: &[u16; 2] = bs
0000 | 80 ef 3b 34 5f 55 00 00
-----+ 0x555f343bef80: [u16; 2] = *bs
0000 | de ad be ef
```

## Vecs

```rust
fn vecs() {
    let bs = vec![0xadde_u16, 0xefbe];
    binspect!(bs);
    binspect!(bs . as_ref() as & [u16]);
    binspect!(* bs);
}
```

```text
-----+ 0x7ffe4d2f6ee8: alloc::vec::Vec<u16> = bs
0000 | 40 bb 73 35 5f 55 00 00 : 02 00 00 00 00 00 00 00
0010 | 02 00 00 00 00 00 00 00
-----+ 0x7ffe4d2f6f88: &[u16] = bs.as_ref() as &[u16]
0000 | 40 bb 73 35 5f 55 00 00 : 02 00 00 00 00 00 00 00
-----+ 0x555f3573bb40: [u16] = *bs
0000 | de ad be ef
```

## Strs

```rust
fn strs() {
    let s = "Hello, world!";
    binspect!(s);
    binspect!(* s);
    let s = "あ";
    binspect!(s);
    binspect!(* s);
    let s = "😇";
    binspect!(s);
    binspect!(* s);
}
```

```text
-----+ 0x7ffe4d2f6f60: &str = s
0000 | 18 fb 3b 34 5f 55 00 00 : 0d 00 00 00 00 00 00 00
-----+ 0x555f343bfb18: str = *s
0000 | 48 65 6c 6c 6f 2c 20 77 : 6f 72 6c 64 21
-----+ 0x7ffe4d2f6f88: &str = s
0000 | 28 fb 3b 34 5f 55 00 00 : 03 00 00 00 00 00 00 00
-----+ 0x555f343bfb28: str = *s
0000 | e3 81 82
-----+ 0x7ffe4d2f6f70: &str = s
0000 | a4 ef 3b 34 5f 55 00 00 : 04 00 00 00 00 00 00 00
-----+ 0x555f343befa4: str = *s
0000 | f0 9f 98 87
```

## Strings

```rust
fn strings() {
    let s = "Hello, world!".to_owned();
    binspect!(s);
    binspect!(s . as_str());
    binspect!(* s);
    let s = "あ".to_owned();
    binspect!(s);
    binspect!(s . as_str());
    binspect!(* s);
    let s = "😇".to_owned();
    binspect!(s);
    binspect!(s . as_str());
    binspect!(* s);
}
```

```text
-----+ 0x7ffe4d2f6f88: alloc::string::String = s
0000 | 40 bb 73 35 5f 55 00 00 : 0d 00 00 00 00 00 00 00
0010 | 0d 00 00 00 00 00 00 00
-----+ 0x7ffe4d2f6f70: &str = s.as_str()
0000 | 40 bb 73 35 5f 55 00 00 : 0d 00 00 00 00 00 00 00
-----+ 0x555f3573bb40: str = *s
0000 | 48 65 6c 6c 6f 2c 20 77 : 6f 72 6c 64 21
-----+ 0x7ffe4d2f6f70: alloc::string::String = s
0000 | 60 bb 73 35 5f 55 00 00 : 03 00 00 00 00 00 00 00
0010 | 03 00 00 00 00 00 00 00
-----+ 0x7ffe4d2f6f60: &str = s.as_str()
0000 | 60 bb 73 35 5f 55 00 00 : 03 00 00 00 00 00 00 00
-----+ 0x555f3573bb60: str = *s
0000 | e3 81 82
-----+ 0x7ffe4d2f6ee8: alloc::string::String = s
0000 | 80 bb 73 35 5f 55 00 00 : 04 00 00 00 00 00 00 00
0010 | 04 00 00 00 00 00 00 00
-----+ 0x7ffe4d2f6fa0: &str = s.as_str()
0000 | 80 bb 73 35 5f 55 00 00 : 04 00 00 00 00 00 00 00
-----+ 0x555f3573bb80: str = *s
0000 | f0 9f 98 87
```

## Trait Objects

```rust
trait T1 {
    fn m1(&self) { println!("trait T1"); }
}
impl T1 for S4 {
    fn m1(&self) { println!("impl T1 for S4"); }
}
fn trait_objects() {
    let t: &dyn T1 = &S4{x: 0x11_u8, y: 0x2222_u16, z: 0x33_u8,};
    binspect!(t);
    binspect!(* t);
}
```

```text
-----+ 0x7ffe4d2f6f70: &dyn all::T1 = t
0000 | 98 ef 3b 34 5f 55 00 00 : 18 e4 3c 34 5f 55 00 00
-----+ 0x555f343bef98: dyn all::T1 = *t
0000 | 22 22 11 33
```

## Boxes

```rust
fn boxes() {
    let s = Box::new(S4{x: 0x11_u8, y: 0x2222_u16, z: 0x33_u8,});
    binspect!(s);
    let p = Box::into_raw(s);
    binspect!(* unsafe { & * p });
    unsafe { Box::from_raw(p) };
    let t: Box<dyn T1> = Box::new(S4{x: 0x11_u8, y: 0x2222_u16, z: 0x33_u8,});
    binspect!(t);
    let p = Box::into_raw(t);
    binspect!(& unsafe { & * p });
    unsafe { Box::from_raw(p) };
}
```

```text
-----+ 0x7ffe4d2f6fb0: alloc::boxed::Box<all::S4> = s
0000 | 40 bb 73 35 5f 55 00 00
-----+ 0x555f3573bb40: all::S4 = *unsafe { &*p }
0000 | 22 22 11 33
-----+ 0x7ffe4d2f6f88: alloc::boxed::Box<dyn all::T1> = t
0000 | 40 bb 73 35 5f 55 00 00 : 18 e4 3c 34 5f 55 00 00
-----+ 0x7ffe4d2f6fc8: &&dyn all::T1 = &unsafe { &*p }
0000 | 70 6f 2f 4d fe 7f 00 00
```

## Options

```rust
fn options() {
    binspect!(Some(255));
    binspect!(None as Option < i32 >);
    let s2 = S2{x: 255,};
    binspect!(Some(& s2));
    binspect!(None as Option < & S2 >);
    binspect!(Some(& s2 as * const _));
    binspect!(None as Option < * const S2 >);
}
```

```text
-----+ 0x555f343bf620: core::option::Option<i32> = Some(255)
0000 | 01 00 00 00 ff 00 00 00
-----+ 0x555f343bf628: core::option::Option<i32> = None as Option<i32>
0000 | 00 00 00 00 00 00 00 00
-----+ 0x7ffe4d2f6fa0: core::option::Option<&all::S2> = Some(&s2)
0000 | b8 6f 2f 4d fe 7f 00 00
-----+ 0x555f343bf628: core::option::Option<&all::S2> = None as Option<&S2>
0000 | 00 00 00 00 00 00 00 00
-----+ 0x7ffe4d2f6f70: core::option::Option<*const all::S2> = Some(&s2 as *const _)
0000 | 01 00 00 00 00 00 00 00 : b8 6f 2f 4d fe 7f 00 00
-----+ 0x555f343be0f0: core::option::Option<*const all::S2> = None as Option<*const S2>
0000 | 00 00 00 00 00 00 00 00 : 00 00 00 00 00 00 00 00
```

