//! Traits, helpers, and type definitions for core I/O functionality.
//!
//! By default, this module simply re-exports the parts of [`std::io`] that are
//! used by binrw. In no_std environments, a compatible subset API is exposed
//! instead.

pub mod prelude;
#[cfg(all(doc, not(feature = "std")))]
extern crate std;
#[cfg(not(feature = "std"))]
mod no_std;
#[cfg(not(feature = "std"))]
pub use no_std::*;
#[cfg(feature = "std")]
pub use std::io::{Bytes, Cursor, Error, ErrorKind, Read, Result, Seek, SeekFrom, Write};
