use bingrep123::Config;
use std::env;
use std::process;

use bingrep123::OsType;

fn main() {
    let args = env::args();
    let config = Config::new(args).unwrap_or_else(|err| {
        // 输出到标准错误
        eprintln!("Problem parsing argument: {}", err);
        process::exit(1);
    });

    if let Err(e) = bingrep123::run(config) {
        // 输出到标准错误
        eprintln!("app error: {}", e);
        process::exit(1);
    }

    println!("{:?}", OsType::MaOS)
}
