use super::{consts, Elf32, ElfReader};

#[test]
pub fn elf32_test() {
    let file: [u8; 52] = [
        0x7f, 0x45, 0x4C, 0x46, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x02, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x00, 0x20, 0x00, 0x00,
        0x00, 0x28, 0x00, 0x00, 0x00, 0x0D, 0x00,
    ];
    let read = ElfReader::<Elf32>::parse(&file).unwrap();
    let hdr = read.get_header();

    assert_eq!(hdr.e_ident.ei_osabi, consts::ELFOSABI_NONE);
    assert_eq!(hdr.e_machine, consts::EM_386);
}
