# bindgen-cfg

Specify bindgen settings using yaml.

## Example

build.rs:

```rust
use std::path::PathBuf;

use bindgen_cfg::BuilderExt;

fn main() {
    let out_path = PathBuf::from(env::var("OUT_DIR").unwrap());
    bindgen::builder()
        .header("wrapper.h")
        .parse_callbacks(Box::new(bindgen::CargoCallbacks))
        .config("bindgen.yaml")
        .expect("bindgen config is present and well formed")
        .generate()
        .write_to_file(out_path.join("bindings.rs"))
        .expect("write SPDK bindings");
}
```

bindgen.yaml:

```yaml
opaque:
  - spdk_nvme_ctrlr
  - spdk_nvme_ctrlr_data
  - spdk_nvme_qpair
  - spdk_nvme_ns
  - spdk_nvme_cpl
  - spdk_nvme_health_information_page
  - spdk_nvme_sgl_descriptor
type:
  block:
    - spdk_nvme_tcp_rsp
    - spdk_nvme_tcp_cmd
    - spdk_nvmf_fabric_prop_get_rsp
    - spdk_nvmf_fabric_connect_rsp
    - spdk_nvmf_fabric_connect_cmd
    - spdk_nvmf_fabric_auth_send_cmd
    - spdk_nvmf_fabric_auth_recv_cmd
block:
  - IPPORT_RESERVED
  - FP_NORMAL
  - FP_SUBNORMAL
  - FP_ZERO
  - FP_INFINITE
  - FP_NAN
```

## Config Schema

```yaml
block: # a list of items to block (Builder::blocklist_item; alias "blacklist")
  - item_name
function: # a block/allow filter for functions
  allow: # (Builder::allowlist_function; alias "whitelist")
    - func_name
  block: # (Builder::blocklist_function; alias "blacklist")
    - func_name
variable: # an allow filter for functions; no block list
  allow: # (Builder::allowlist_var; alias "whitelist")
    - var_name
type: # a block/allow filter for types
  allow: # (Builder::allowlist_type; alias "whitelist")
    - type_name
  block: # (Builder::blocklist_type; alias "blacklist")
    - type_name
opaque: # a list of opaque types (Builder::opaque_type)
  - type_name
enum: # a mapping between enum names and their code gen type
  enum1: bitfield # (Builder::bitfield_enum; alias "b")
  enum2: new_type # (Builder::newtype_enum; alias "nt")
  enum3: rustified # (Builder::rustified_enum; alias "r")
  enum4: rustified_non_exhaustive # (Builder::rustified_non_exhaustive_enum; alias "rne")
  enum5: constified # (Builder::constified_enum; alias "c")
  enum6: constified_module # (Builder::constified_enum_module; alias "cm")
```

## License

Licensed under either of

 * Apache License, Version 2.0
   ([LICENSE-APACHE](LICENSE-APACHE) or http://www.apache.org/licenses/LICENSE-2.0)
 * MIT license
   ([LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT)

at your option.

## Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you, as defined in the Apache-2.0 license, shall be
dual licensed as above, without any additional terms or conditions.

No other config options were relevant for my use case, but I am open to merge
requests to add new config options.
