# bindet (binary file type detection)

Fast file type detection. Read more here: [documentation](https://docs.rs/bindet)

# Supported file types

- Zip
- Rar (Rar 4 and 5)
- Tar
- Png
- Jpg
- 7-zip
- Opus
- Vorbis
- Mp3
- Webp
- Flac
- Matroska (mkv, mka, mks, mk3d, webm)
- Wasm
- Java Class
- Elf (Executable and Linkable Format)
- Wav
- Avi
- Aiff
- Tiff
- Sqlite3 (`.db`)
- Ico
- others are on the road

# Example:

```rust
use std::fs::{OpenOptions};
use std::io::BufReader;
use std::io::ErrorKind;
use bindet;
use bindet::types::FileType;
use bindet::FileTypeMatch;
use bindet::FileTypeMatches;

fn example() {
    let file = OpenOptions::new().read(true).open("files/test.tar").unwrap();
    let buf = BufReader::new(file);

    let detect = bindet::detect(buf).map_err(|e| e.kind());
    let expected: Result<Option<FileTypeMatches>, ErrorKind> = Ok(Some(FileTypeMatches::new(
        vec![FileType::Tar],
        vec![FileTypeMatch::new(FileType::Tar, true)]
    )));

    assert_eq!(detect, expected);
}
```