//     bindet - Fast binary file type detection
//
//         The MIT License (MIT)
//
//      Copyright (c) Obliter Software (https://github.com/oblitersoftware/)
//      Copyright (c) contributors
//
//      Permission is hereby granted, free of charge, to any person obtaining a copy
//      of this software and associated documentation files (the "Software"), to deal
//      in the Software without restriction, including without limitation the rights
//      to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//      copies of the Software, and to permit persons to whom the Software is
//      furnished to do so, subject to the following conditions:
//
//      The above copyright notice and this permission notice shall be included in
//      all copies or substantial portions of the Software.
//
//      THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//      IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//      FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//      AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//      LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//      OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//      THE SOFTWARE.

//! Fast binary file type detection
//!
//! `bindet` provides a fast and safe binary file detection even for large files.
//!
//! The worst case for `bindet` is `O(n)`, but some tricks are applied to try to amortize
//! the time complexity to `O(1)`, so in most of the cases it does not take `O(n)` to execute.
//!
//! File detection is made in a two-pass process, first it tries to read the largest file-type block,
//! for example, [`FileType::Zip`](FileType::Zip) files does have a Local File Header which starts
//! with a 4-byte descriptor, but [`FileType::Rar5`](FileType::Rar5) signatures can be found anywhere
//! in the file up to the SFX module size, which of [`FileType::Rar5`](FileType::Rar5) is of `1MB`,
//! to avoid reading `1MB` right at the start, it looks to the smallest possible detection size,
//! which is defined by the [`FileTypeDescription`] trait.
//!
//! The second step is to look at the end of file, in a sliding window fashion, trying to find a sequence
//! that matches the specification, like the `End of central directory signature` of [`FileType::Zip`](FileType::Zip).
//!
use std::io::{Read, BufReader, Seek};
use std::fs::{File};
use crate::types::FileType;

pub mod types;
pub mod description;
pub mod matcher;

struct FileTypeMatch {
    file_type: FileType,
    full_match: bool
}

struct FileTypeMatches {
    likely_to_be: Vec<FileType>,
    matches: Vec<FileTypeMatch>
}


/// [FileType](FileType)
fn detect<R>(read: R) -> Option<FileTypeMatches> where R: Read, R: Seek {
    None
}


#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }
}
