use crate::matcher::Position;
use crate::types::FileType;

pub trait FileTypeDescription {
    fn smallest_block_size(&self, position: Position) -> usize;
    fn largest_block_size(&self, position: Position) -> usize;
}

impl FileTypeDescription for FileType {
    fn smallest_block_size(&self, position: Position) -> usize {
        match self {
            FileType::Zip => 4,
            FileType::Rar => 7,
            FileType::Rar5 => 8,
            FileType::Tar => 257+8,
        }
        todo!()
    }

    fn largest_block_size(&self, position: Position) -> usize {
        todo!()
    }
}