#![cfg(feature = "atomic")]

mod utils;

use core::sync::atomic::{
    AtomicBool, AtomicI16, AtomicI32, AtomicI64, AtomicI8, AtomicIsize, AtomicU16, AtomicU32,
    AtomicU64, AtomicU8, AtomicUsize, Ordering,
};
use utils::the_same_with_comparer;

#[test]
fn test_atomic_commons() {
    the_same_with_comparer(AtomicBool::new(true), |a, b| {
        a.load(Ordering::SeqCst) == b.load(Ordering::SeqCst)
    });
    the_same_with_comparer(AtomicBool::new(false), |a, b| {
        a.load(Ordering::SeqCst) == b.load(Ordering::SeqCst)
    });
    the_same_with_comparer(AtomicU8::new(0), |a, b| {
        a.load(Ordering::SeqCst) == b.load(Ordering::SeqCst)
    });
    the_same_with_comparer(AtomicU16::new(0), |a, b| {
        a.load(Ordering::SeqCst) == b.load(Ordering::SeqCst)
    });
    the_same_with_comparer(AtomicU32::new(0), |a, b| {
        a.load(Ordering::SeqCst) == b.load(Ordering::SeqCst)
    });
    the_same_with_comparer(AtomicU64::new(0), |a, b| {
        a.load(Ordering::SeqCst) == b.load(Ordering::SeqCst)
    });
    the_same_with_comparer(AtomicUsize::new(0), |a, b| {
        a.load(Ordering::SeqCst) == b.load(Ordering::SeqCst)
    });
    the_same_with_comparer(AtomicI8::new(0), |a, b| {
        a.load(Ordering::SeqCst) == b.load(Ordering::SeqCst)
    });
    the_same_with_comparer(AtomicI16::new(0), |a, b| {
        a.load(Ordering::SeqCst) == b.load(Ordering::SeqCst)
    });
    the_same_with_comparer(AtomicI32::new(0), |a, b| {
        a.load(Ordering::SeqCst) == b.load(Ordering::SeqCst)
    });
    the_same_with_comparer(AtomicI64::new(0), |a, b| {
        a.load(Ordering::SeqCst) == b.load(Ordering::SeqCst)
    });
    the_same_with_comparer(AtomicIsize::new(0), |a, b| {
        a.load(Ordering::SeqCst) == b.load(Ordering::SeqCst)
    });
}
