use crate::{de::Decode, enc::Encode};
use core::sync::atomic::{
    AtomicBool, AtomicI16, AtomicI32, AtomicI64, AtomicI8, AtomicIsize, AtomicU16, AtomicU32,
    AtomicU64, AtomicU8, AtomicUsize, Ordering,
};

impl Encode for AtomicBool {
    fn encode<E: crate::enc::Encoder>(&self, encoder: E) -> Result<(), crate::error::EncodeError> {
        self.load(Ordering::SeqCst).encode(encoder)
    }
}

impl Decode for AtomicBool {
    fn decode<D: crate::de::Decoder>(decoder: D) -> Result<Self, crate::error::DecodeError> {
        Ok(AtomicBool::new(Decode::decode(decoder)?))
    }
}

impl Encode for AtomicU8 {
    fn encode<E: crate::enc::Encoder>(&self, encoder: E) -> Result<(), crate::error::EncodeError> {
        self.load(Ordering::SeqCst).encode(encoder)
    }
}

impl Decode for AtomicU8 {
    fn decode<D: crate::de::Decoder>(decoder: D) -> Result<Self, crate::error::DecodeError> {
        Ok(AtomicU8::new(Decode::decode(decoder)?))
    }
}

impl Encode for AtomicU16 {
    fn encode<E: crate::enc::Encoder>(&self, encoder: E) -> Result<(), crate::error::EncodeError> {
        self.load(Ordering::SeqCst).encode(encoder)
    }
}

impl Decode for AtomicU16 {
    fn decode<D: crate::de::Decoder>(decoder: D) -> Result<Self, crate::error::DecodeError> {
        Ok(AtomicU16::new(Decode::decode(decoder)?))
    }
}

impl Encode for AtomicU32 {
    fn encode<E: crate::enc::Encoder>(&self, encoder: E) -> Result<(), crate::error::EncodeError> {
        self.load(Ordering::SeqCst).encode(encoder)
    }
}

impl Decode for AtomicU32 {
    fn decode<D: crate::de::Decoder>(decoder: D) -> Result<Self, crate::error::DecodeError> {
        Ok(AtomicU32::new(Decode::decode(decoder)?))
    }
}

impl Encode for AtomicU64 {
    fn encode<E: crate::enc::Encoder>(&self, encoder: E) -> Result<(), crate::error::EncodeError> {
        self.load(Ordering::SeqCst).encode(encoder)
    }
}

impl Decode for AtomicU64 {
    fn decode<D: crate::de::Decoder>(decoder: D) -> Result<Self, crate::error::DecodeError> {
        Ok(AtomicU64::new(Decode::decode(decoder)?))
    }
}

impl Encode for AtomicUsize {
    fn encode<E: crate::enc::Encoder>(&self, encoder: E) -> Result<(), crate::error::EncodeError> {
        self.load(Ordering::SeqCst).encode(encoder)
    }
}

impl Decode for AtomicUsize {
    fn decode<D: crate::de::Decoder>(decoder: D) -> Result<Self, crate::error::DecodeError> {
        Ok(AtomicUsize::new(Decode::decode(decoder)?))
    }
}

impl Encode for AtomicI8 {
    fn encode<E: crate::enc::Encoder>(&self, encoder: E) -> Result<(), crate::error::EncodeError> {
        self.load(Ordering::SeqCst).encode(encoder)
    }
}

impl Decode for AtomicI8 {
    fn decode<D: crate::de::Decoder>(decoder: D) -> Result<Self, crate::error::DecodeError> {
        Ok(AtomicI8::new(Decode::decode(decoder)?))
    }
}

impl Encode for AtomicI16 {
    fn encode<E: crate::enc::Encoder>(&self, encoder: E) -> Result<(), crate::error::EncodeError> {
        self.load(Ordering::SeqCst).encode(encoder)
    }
}

impl Decode for AtomicI16 {
    fn decode<D: crate::de::Decoder>(decoder: D) -> Result<Self, crate::error::DecodeError> {
        Ok(AtomicI16::new(Decode::decode(decoder)?))
    }
}

impl Encode for AtomicI32 {
    fn encode<E: crate::enc::Encoder>(&self, encoder: E) -> Result<(), crate::error::EncodeError> {
        self.load(Ordering::SeqCst).encode(encoder)
    }
}

impl Decode for AtomicI32 {
    fn decode<D: crate::de::Decoder>(decoder: D) -> Result<Self, crate::error::DecodeError> {
        Ok(AtomicI32::new(Decode::decode(decoder)?))
    }
}

impl Encode for AtomicI64 {
    fn encode<E: crate::enc::Encoder>(&self, encoder: E) -> Result<(), crate::error::EncodeError> {
        self.load(Ordering::SeqCst).encode(encoder)
    }
}

impl Decode for AtomicI64 {
    fn decode<D: crate::de::Decoder>(decoder: D) -> Result<Self, crate::error::DecodeError> {
        Ok(AtomicI64::new(Decode::decode(decoder)?))
    }
}

impl Encode for AtomicIsize {
    fn encode<E: crate::enc::Encoder>(&self, encoder: E) -> Result<(), crate::error::EncodeError> {
        self.load(Ordering::SeqCst).encode(encoder)
    }
}

impl Decode for AtomicIsize {
    fn decode<D: crate::de::Decoder>(decoder: D) -> Result<Self, crate::error::DecodeError> {
        Ok(AtomicIsize::new(Decode::decode(decoder)?))
    }
}
