# binairo

---
## About

* A command-line tool for solving binairo ( or takuzu https://en.wikipedia.org/wiki/Takuzu ) puzzles.
* Install by running: `cargo install binairo`

---
## binairo rules

As far as i know, the objective is to fill a quadratic NxN grid with 1s and 0s, so that
* there is an equal number of 1s and 0s in each row and column of the grid and
* there is no cell that has the same number in the left and right cell or in the upper and down cell.

---
## Commands

`binairo` will read 2 arguments. The first one is mandatory:
* `binairo <input-file-name> <number of solutions to print>`

'input-file-name' should be the file that defines the starting board (see ./examples directory)

'number of solutions to print' defaults to 1

---
 ## Examples

compile
```
$ cargo build --release
   Compiling binairo v0.1.0 (/home/davezwieback/rust_src/binairo)
    Finished release [optimized] target(s) in 1.12s
```

and search for the first solution of one of the examples
```
$ ./target/release/binairo ./examples/6x6.cfg
  Will read input file: ./examples/6x6.cfg
  Starting for:
  ╔═══════════════════════╗
  ║ . │ 1 │ . │ . │ . │ . ║
  ║───┼───┼───┼───┼───┼───║
  ║ . │ . │ . │ . │ . │ 1 ║
  ║───┼───┼───┼───┼───┼───║
  ║ . │ . │ . │ 0 │ . │ . ║
  ║───┼───┼───┼───┼───┼───║
  ║ 0 │ . │ . │ 0 │ . │ . ║
  ║───┼───┼───┼───┼───┼───║
  ║ . │ . │ . │ . │ 1 │ . ║
  ║───┼───┼───┼───┼───┼───║
  ║ . │ 1 │ 1 │ . │ 1 │ . ║
  ╚═══════════════════════╝

  Found 1 Solution(s):

  ╔═══════════════════════╗
  ║ 0 │ 1 │ 0 │ 1 │ 0 │ 1 ║
  ║───┼───┼───┼───┼───┼───║
  ║ 1 │ 0 │ 0 │ 1 │ 0 │ 1 ║
  ║───┼───┼───┼───┼───┼───║
  ║ 1 │ 0 │ 1 │ 0 │ 1 │ 0 ║
  ║───┼───┼───┼───┼───┼───║
  ║ 0 │ 1 │ 1 │ 0 │ 0 │ 1 ║
  ║───┼───┼───┼───┼───┼───║
  ║ 1 │ 0 │ 0 │ 1 │ 1 │ 0 ║
  ║───┼───┼───┼───┼───┼───║
  ║ 0 │ 1 │ 1 │ 0 │ 1 │ 0 ║
  ╚═══════════════════════╝

  Time: 0.000047579 sec
```


search for the first 5 solutions of one of the examples ( in fact, there are only 3)
```
$ ./target/release/binairo ./examples/10x10.cfg 5
  Will read input file: ./examples/10x10.cfg
  Starting for:
  ╔═══════════════════════════════════════╗
  ║ . │ . │ . │ . │ . │ . │ 1 │ 0 │ . │ . ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ . │ 0 │ . │ . │ . │ . │ . │ . │ . │ . ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ . │ . │ 1 │ . │ . │ 1 │ . │ 1 │ . │ . ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ . │ 0 │ 1 │ 0 │ . │ 0 │ . │ . │ . │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ . │ 0 │ . │ . │ . │ . │ 0 │ . │ 1 │ . ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ . │ . │ . │ . │ 0 │ . │ . │ 1 │ 1 │ . ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ . │ . │ 0 │ . │ . │ . │ . │ . │ . │ . ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ . │ . │ . │ . │ 0 │ 1 │ . │ . │ . │ . ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 1 │ . │ 0 │ . │ 1 │ . │ . │ . │ . ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ . │ . │ . │ 1 │ . │ . │ . │ . │ 0 ║
  ╚═══════════════════════════════════════╝

  Found 3 Solution(s):

  ╔═══════════════════════════════════════╗
  ║ 0 │ 0 │ 1 │ 1 │ 0 │ 0 │ 1 │ 0 │ 1 │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 0 │ 0 │ 1 │ 0 │ 0 │ 1 │ 0 │ 1 │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 0 │ 1 │ 1 │ 0 │ 1 │ 1 │ 0 │ 1 │ 0 │ 0 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 0 │ 0 │ 1 │ 0 │ 1 │ 0 │ 1 │ 1 │ 0 │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 0 │ 0 │ 1 │ 0 │ 1 │ 0 │ 0 │ 1 │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 0 │ 1 │ 1 │ 0 │ 0 │ 1 │ 0 │ 1 │ 1 │ 0 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 1 │ 0 │ 0 │ 1 │ 0 │ 1 │ 1 │ 0 │ 0 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 0 │ 0 │ 1 │ 1 │ 0 │ 1 │ 1 │ 0 │ 0 │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 1 │ 0 │ 0 │ 1 │ 1 │ 0 │ 0 │ 1 │ 0 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 1 │ 0 │ 1 │ 1 │ 0 │ 0 │ 1 │ 0 │ 0 ║
  ╚═══════════════════════════════════════╝


  ╔═══════════════════════════════════════╗
  ║ 0 │ 0 │ 1 │ 1 │ 0 │ 0 │ 1 │ 0 │ 1 │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 0 │ 0 │ 1 │ 1 │ 0 │ 1 │ 0 │ 0 │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 0 │ 1 │ 1 │ 0 │ 0 │ 1 │ 0 │ 1 │ 1 │ 0 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 0 │ 0 │ 1 │ 0 │ 1 │ 0 │ 1 │ 1 │ 0 │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 0 │ 0 │ 1 │ 0 │ 1 │ 0 │ 0 │ 1 │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 0 │ 1 │ 1 │ 0 │ 0 │ 1 │ 0 │ 1 │ 1 │ 0 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 1 │ 0 │ 0 │ 1 │ 0 │ 1 │ 1 │ 0 │ 0 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 0 │ 0 │ 1 │ 1 │ 0 │ 1 │ 1 │ 0 │ 0 │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 1 │ 0 │ 0 │ 1 │ 1 │ 0 │ 0 │ 1 │ 0 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 1 │ 0 │ 1 │ 1 │ 0 │ 0 │ 1 │ 0 │ 0 ║
  ╚═══════════════════════════════════════╝


  ╔═══════════════════════════════════════╗
  ║ 0 │ 1 │ 1 │ 0 │ 1 │ 0 │ 1 │ 0 │ 0 │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 0 │ 0 │ 1 │ 0 │ 0 │ 1 │ 0 │ 1 │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 0 │ 1 │ 1 │ 0 │ 0 │ 1 │ 0 │ 1 │ 1 │ 0 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 0 │ 0 │ 1 │ 0 │ 1 │ 0 │ 1 │ 1 │ 0 │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 0 │ 0 │ 1 │ 0 │ 1 │ 0 │ 0 │ 1 │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 0 │ 1 │ 1 │ 0 │ 0 │ 1 │ 0 │ 1 │ 1 │ 0 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 0 │ 0 │ 1 │ 1 │ 0 │ 1 │ 1 │ 0 │ 0 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 0 │ 0 │ 1 │ 1 │ 0 │ 1 │ 1 │ 0 │ 0 │ 1 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 1 │ 0 │ 0 │ 1 │ 1 │ 0 │ 0 │ 1 │ 0 ║
  ║───┼───┼───┼───┼───┼───┼───┼───┼───┼───║
  ║ 1 │ 1 │ 0 │ 1 │ 1 │ 0 │ 0 │ 1 │ 0 │ 0 ║
  ╚═══════════════════════════════════════╝

  Time: 0.000597198 sec
```

---
## Greetings

Thank you too everyone who participated in the development of rust, cargo, atom or any crate. I really enjoyed to benefit from this great work.
