use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     CommentActionView,
     CommonActionEventsView,
     CreatedView,
     CreditCardPaymentIntentView,
     CreditCardPaymentView,
     DateTime,
     DeliveryMethodTypeView,
     Guid,
     ReconciliationInvoiceActionEntryView,
     ReconciliationInvoiceActionSubsView,
     ReconciliationInvoiceActionView,
     RegisterReconciliationPaymentView,
     SendReconciliationInvoiceReminderView,
    
};


impl Client {
    
    

/// The autogiro withdrawal can be cancelled using this endpoint. Note that this can't be done up to the day before the autogiro withdrawal date
/// - **id**: Reconciliation invoice public id
pub async fn reconciliation_invoice_cancel_autogiro_withdrawal(&self,id: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("autogiro"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// The credit card payment can be cancelled if payment has not been completed yet.
/// - **id**: Credit card payment public Id
pub async fn reconciliation_invoice_cancel_credit_card_payment(&self,id: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("creditcardpayment"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Writes a comment to the self invoice events log.
pub async fn reconciliation_invoice_comment_a_reconciliation_invoice(&self,body: CommentActionView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("comment"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Make a credit card payment intent with the amount on the invoice.
pub async fn reconciliation_invoice_create_credit_card_payment_intent(&self,body: CreditCardPaymentIntentView,
                         
) -> Result<CreditCardPaymentView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("creditcardpayment"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Unlike invoices (Invoice endpoints) the reconciliation invoices are not created as drafts. Once a reconciliation invoice is created it is considered as attested and any automatic operations (such as delivering the invoice) is executed.
pub async fn reconciliation_invoice_create_reconciliation_invoice(&self,body: ReconciliationInvoiceActionEntryView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("action"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Unlike invoices (Invoice endpoints) a reconciliation invoices can be delete all the time. Set Amount to 0 if you want to close it but not delete it.
/// - **id**: Reconciliation invoice public id
pub async fn reconciliation_invoice_delete_a_reconciliation_invoice(&self,id: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("action"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Retrieves all reconciliation invoices that have a closed/full payment date between the specified from and to dates.
/// - **id**: Creditor public id
/// - **from**: From date
/// - **to**: To date
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn reconciliation_invoice_get_all_closed_reconciliation_invoices(&self,id: Guid,
                         from: DateTime,
                         to: DateTime,
                         offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<ReconciliationInvoiceActionSubsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("closed"))
        .url(Param::value(id))
        .query("from", Param::value(from))
        .query("to", Param::value(to))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// 
/// - **id**: Creditor public id
/// - **from**: From date
/// - **to**: To date
pub async fn reconciliation_invoice_get_all_events_for_all_reconciliation_invoices(&self,id: Guid,
                         from: DateTime,
                         to: DateTime,
                         
) -> Result<CommonActionEventsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("events"))
        .url(Param::value(id))
        .query("from", Param::value(from))
        .query("to", Param::value(to))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Retrieves all unpaid reconciliation invoices.
/// - **id**: Creditor public id
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn reconciliation_invoice_get_all_open_reconciliation_invoices(&self,id: Guid,
                         offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<ReconciliationInvoiceActionSubsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("open"))
        .url(Param::value(id))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Returns a reconciliation invoice based on the ActionPublicId. All reconciliation invoices have a unique ActionPublicId that is generated on creation.
/// - **id**: Reconciliation invoice public id
pub async fn reconciliation_invoice_get_reconciliation_invoice(&self,id: Guid,
                         
) -> Result<ReconciliationInvoiceActionView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("action"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// The credit card payment can be refunded if payment has been completed.
/// - **id**: Credit card payment public Id
pub async fn reconciliation_invoice_refund_credit_card_payment(&self,id: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("refundcreditcardpayment"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// The swish payment can be refunded if payment has been completed.
/// - **id**: Swish payment token/public id
pub async fn reconciliation_invoice_refund_swish_payment(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("refundswishpayment"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Register a payment on the reconciliation invoice. This endpoint is preferred before updating the reconciliation invoice with new amount. Registering payment through this endpoint will keep history of the payment and creditation log.
pub async fn reconciliation_invoice_register_payment_on_a_reconciliation_invoice(&self,body: RegisterReconciliationPaymentView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("registerpayment"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Sends the reconciliation invoice with the preferred delivery method. Note that omitting optional parameters will use pre-stored values on the invoice.
/// - **id**: Reconciliation invoice public id
/// - **method**: The method to send the reconciliation invoice
/// - **isprioritymail**: Is prioritized mail. Used for Mail deliveries only
/// - **iscolorized**: Is colorized mail. Used for Mail deliveries only
pub async fn reconciliation_invoice_send_the_reconciliation_invoice(&self,id: Guid,
                         method: Option<DeliveryMethodTypeView>,
                         isprioritymail: Option<bool>,
                         iscolorized: Option<bool>,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("sendinvoice"))
        .url(Param::value(id))
        .query("method", Param::opt(method))
        .query("isprioritymail", Param::opt(isprioritymail))
        .query("iscolorized", Param::opt(iscolorized))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Send the reminder invoice for the reconciliation invoice. Reminder fees and PDF:s will be added to the reconcilation invoice
pub async fn reconciliation_invoice_send_the_reminder_invoice_with_pregenerated_pdf(&self,body: SendReconciliationInvoiceReminderView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("sendreminderinvoice"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Unlike invoices (Invoice endpoints) a reconciliation invoices can be updated all the time. Please note, by changing the amounts all payment history is deleted.
/// - **id**: Reconciliation invoice public id
pub async fn reconciliation_invoice_update_reconciliation_invoice(&self,id: Guid,
                         body: ReconciliationInvoiceActionEntryView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("reconciliationinvoice"))
        .url(Param::value("action"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
}