
use crate::models::DateTime; 
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct YearlyAutogiroContractInvoiceView {
    
    #[serde(rename = "AccountNumber", skip_serializing_if = "Option::is_none")]
    pub account_number: Option<String>,
    
    #[serde(rename = "Address", skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    
    #[serde(rename = "Address2", skip_serializing_if = "Option::is_none")]
    pub address2: Option<String>,
    
    #[serde(rename = "Amount", skip_serializing_if = "Option::is_none")]
    pub amount: Option<f64>,
    
    #[serde(rename = "Bank", skip_serializing_if = "Option::is_none")]
    pub bank: Option<String>,
    
    #[serde(rename = "City", skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
    
    #[serde(rename = "ClearingNumber", skip_serializing_if = "Option::is_none")]
    pub clearing_number: Option<String>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "DebtorExternalId", skip_serializing_if = "Option::is_none")]
    pub debtor_external_id: Option<String>,
    
    #[serde(rename = "Email", skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    
    #[serde(rename = "EnableAutomaticDebtCollection", skip_serializing_if = "Option::is_none")]
    pub enable_automatic_debt_collection: Option<bool>,
    
    #[serde(rename = "EnableAutomaticReminder", skip_serializing_if = "Option::is_none")]
    pub enable_automatic_reminder: Option<bool>,
    
    #[serde(rename = "EndDate", skip_serializing_if = "Option::is_none")]
    pub end_date: Option<DateTime>,
    
    #[serde(rename = "Name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    
    #[serde(rename = "Phone", skip_serializing_if = "Option::is_none")]
    pub phone: Option<String>,
    
    #[serde(rename = "SSN", skip_serializing_if = "Option::is_none")]
    pub ssn: Option<String>,
    
    #[serde(rename = "StartDate", skip_serializing_if = "Option::is_none")]
    pub start_date: Option<DateTime>,
    
    #[serde(rename = "WithdrawalDay", skip_serializing_if = "Option::is_none")]
    pub withdrawal_day: Option<i64>,
    
    #[serde(rename = "WithdrawalMonth", skip_serializing_if = "Option::is_none")]
    pub withdrawal_month: Option<i64>,
    
    #[serde(rename = "ZipCode", skip_serializing_if = "Option::is_none")]
    pub zip_code: Option<String>,
    
}