
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct UserRightView {
    
    #[serde(rename = "CanAttestInvoice", skip_serializing_if = "Option::is_none")]
    pub can_attest_invoice: Option<bool>,
    
    #[serde(rename = "CanAttestSupplierInvoice", skip_serializing_if = "Option::is_none")]
    pub can_attest_supplier_invoice: Option<bool>,
    
    #[serde(rename = "CanManageDebtCollections", skip_serializing_if = "Option::is_none")]
    pub can_manage_debt_collections: Option<bool>,
    
    #[serde(rename = "CanManageFinances", skip_serializing_if = "Option::is_none")]
    pub can_manage_finances: Option<bool>,
    
    #[serde(rename = "CanManageInvoicePayments", skip_serializing_if = "Option::is_none")]
    pub can_manage_invoice_payments: Option<bool>,
    
    #[serde(rename = "CanManageInvoices", skip_serializing_if = "Option::is_none")]
    pub can_manage_invoices: Option<bool>,
    
    #[serde(rename = "CanManageSelfInvoices", skip_serializing_if = "Option::is_none")]
    pub can_manage_self_invoices: Option<bool>,
    
    #[serde(rename = "CanManageSupplierInvoices", skip_serializing_if = "Option::is_none")]
    pub can_manage_supplier_invoices: Option<bool>,
    
    #[serde(rename = "CanPaySupplierInvoice", skip_serializing_if = "Option::is_none")]
    pub can_pay_supplier_invoice: Option<bool>,
    
    #[serde(rename = "CanReadBookkeeping", skip_serializing_if = "Option::is_none")]
    pub can_read_bookkeeping: Option<bool>,
    
    #[serde(rename = "CanReadCreditor", skip_serializing_if = "Option::is_none")]
    pub can_read_creditor: Option<bool>,
    
    #[serde(rename = "CanReadSettings", skip_serializing_if = "Option::is_none")]
    pub can_read_settings: Option<bool>,
    
    #[serde(rename = "CanSalesFinance", skip_serializing_if = "Option::is_none")]
    pub can_sales_finance: Option<bool>,
    
    #[serde(rename = "CanSellInvoice", skip_serializing_if = "Option::is_none")]
    pub can_sell_invoice: Option<bool>,
    
    #[serde(rename = "CanWriteCreditor", skip_serializing_if = "Option::is_none")]
    pub can_write_creditor: Option<bool>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "IncludeCreditorOnStartPage", skip_serializing_if = "Option::is_none")]
    pub include_creditor_on_start_page: Option<bool>,
    
}