
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::Guid; 
use crate::models::OverpaymentDetailsView; 
use crate::models::UnhandledPaymentStateTypeView; 
use crate::models::UnhandledPaymentTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct UnhandledPaymentView {
    
    #[serde(rename = "AdditionalInformations", skip_serializing_if = "Vec::is_empty", default)]
    pub additional_informations: Vec<String>,
    
    #[serde(rename = "Amount", skip_serializing_if = "Option::is_none")]
    pub amount: Option<AmountView>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "OverpaymentDetails", skip_serializing_if = "Option::is_none")]
    pub overpayment_details: Option<OverpaymentDetailsView>,
    
    #[serde(rename = "PaymentDate", skip_serializing_if = "Option::is_none")]
    pub payment_date: Option<DateTime>,
    
    #[serde(rename = "Reference", skip_serializing_if = "Option::is_none")]
    pub reference: Option<String>,
    
    #[serde(rename = "SenderAddress", skip_serializing_if = "Option::is_none")]
    pub sender_address: Option<String>,
    
    #[serde(rename = "SenderBankgiroNo", skip_serializing_if = "Option::is_none")]
    pub sender_bankgiro_no: Option<String>,
    
    #[serde(rename = "SenderCity", skip_serializing_if = "Option::is_none")]
    pub sender_city: Option<String>,
    
    #[serde(rename = "SenderCountryCode", skip_serializing_if = "Option::is_none")]
    pub sender_country_code: Option<String>,
    
    #[serde(rename = "SenderName", skip_serializing_if = "Option::is_none")]
    pub sender_name: Option<String>,
    
    #[serde(rename = "SenderOrgNo", skip_serializing_if = "Option::is_none")]
    pub sender_org_no: Option<String>,
    
    #[serde(rename = "SenderZipCode", skip_serializing_if = "Option::is_none")]
    pub sender_zip_code: Option<String>,
    
    #[serde(rename = "State", skip_serializing_if = "Option::is_none")]
    pub state: Option<UnhandledPaymentStateTypeView>,
    
    #[serde(rename = "UnhandledPaymentPublicId", skip_serializing_if = "Option::is_none")]
    pub unhandled_payment_public_id: Option<Guid>,
    
    #[serde(rename = "UnhandledPaymentType", skip_serializing_if = "Option::is_none")]
    pub unhandled_payment_type: Option<UnhandledPaymentTypeView>,
    
}