
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::SwishStatusTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct SwishPaymentStatusView {
    
    #[serde(rename = "Amount", skip_serializing_if = "Option::is_none")]
    pub amount: Option<AmountView>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "PaidDate", skip_serializing_if = "Option::is_none")]
    pub paid_date: Option<DateTime>,
    
    #[serde(rename = "PaymentRequestToken", skip_serializing_if = "Option::is_none")]
    pub payment_request_token: Option<String>,
    
    #[serde(rename = "Status", skip_serializing_if = "Option::is_none")]
    pub status: Option<SwishStatusTypeView>,
    
}