
use crate::models::ActionTypeView; 
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::FileView; 
use crate::models::Guid; 
use crate::models::OriginTypeView; 
use crate::models::SupplierInvoiceActionStageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct SupplierInvoiceActionSubView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "ActionType", skip_serializing_if = "Option::is_none")]
    pub action_type: Option<ActionTypeView>,
    
    #[serde(rename = "AttestedDate", skip_serializing_if = "Option::is_none")]
    pub attested_date: Option<DateTime>,
    
    #[serde(rename = "ClosedDate", skip_serializing_if = "Option::is_none")]
    pub closed_date: Option<DateTime>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "CreditorName", skip_serializing_if = "Option::is_none")]
    pub creditor_name: Option<String>,
    
    #[serde(rename = "CreditorOrgNo", skip_serializing_if = "Option::is_none")]
    pub creditor_org_no: Option<String>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "CurrentAmount", skip_serializing_if = "Option::is_none")]
    pub current_amount: Option<AmountView>,
    
    #[serde(rename = "DueDate", skip_serializing_if = "Option::is_none")]
    pub due_date: Option<DateTime>,
    
    #[serde(rename = "ExternalSourceId", skip_serializing_if = "Option::is_none")]
    pub external_source_id: Option<String>,
    
    #[serde(rename = "InvoiceDate", skip_serializing_if = "Option::is_none")]
    pub invoice_date: Option<DateTime>,
    
    #[serde(rename = "InvoiceFile", skip_serializing_if = "Option::is_none")]
    pub invoice_file: Option<FileView>,
    
    #[serde(rename = "InvoiceNumber", skip_serializing_if = "Option::is_none")]
    pub invoice_number: Option<String>,
    
    #[serde(rename = "InvoicedAmount", skip_serializing_if = "Option::is_none")]
    pub invoiced_amount: Option<AmountView>,
    
    #[serde(rename = "IsPaused", skip_serializing_if = "Option::is_none")]
    pub is_paused: Option<bool>,
    
    #[serde(rename = "NextEvent", skip_serializing_if = "Option::is_none")]
    pub next_event: Option<String>,
    
    #[serde(rename = "NextEventDate", skip_serializing_if = "Option::is_none")]
    pub next_event_date: Option<DateTime>,
    
    #[serde(rename = "NextPaymentAmount", skip_serializing_if = "Option::is_none")]
    pub next_payment_amount: Option<AmountView>,
    
    #[serde(rename = "NextPaymentDate", skip_serializing_if = "Option::is_none")]
    pub next_payment_date: Option<DateTime>,
    
    #[serde(rename = "OCR", skip_serializing_if = "Option::is_none")]
    pub ocr: Option<String>,
    
    #[serde(rename = "Origin", skip_serializing_if = "Option::is_none")]
    pub origin: Option<OriginTypeView>,
    
    #[serde(rename = "Stage", skip_serializing_if = "Option::is_none")]
    pub stage: Option<SupplierInvoiceActionStageTypeView>,
    
    #[serde(rename = "SupplierName", skip_serializing_if = "Option::is_none")]
    pub supplier_name: Option<String>,
    
    #[serde(rename = "SupplierOrgNo", skip_serializing_if = "Option::is_none")]
    pub supplier_org_no: Option<String>,
    
    #[serde(rename = "SupplierPublicId", skip_serializing_if = "Option::is_none")]
    pub supplier_public_id: Option<Guid>,
    
}