
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::SelfInvoiceActionStageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct SelfInvoiceActionStateView {
    
    #[serde(rename = "AttestedDate", skip_serializing_if = "Option::is_none")]
    pub attested_date: Option<DateTime>,
    
    #[serde(rename = "ClosedDate", skip_serializing_if = "Option::is_none")]
    pub closed_date: Option<DateTime>,
    
    #[serde(rename = "InvoiceSentDate", skip_serializing_if = "Option::is_none")]
    pub invoice_sent_date: Option<DateTime>,
    
    #[serde(rename = "IsPaused", skip_serializing_if = "Option::is_none")]
    pub is_paused: Option<bool>,
    
    #[serde(rename = "NextEvent", skip_serializing_if = "Option::is_none")]
    pub next_event: Option<String>,
    
    #[serde(rename = "NextEventDate", skip_serializing_if = "Option::is_none")]
    pub next_event_date: Option<DateTime>,
    
    #[serde(rename = "NextPaymentAmount", skip_serializing_if = "Option::is_none")]
    pub next_payment_amount: Option<AmountView>,
    
    #[serde(rename = "NextPaymentDate", skip_serializing_if = "Option::is_none")]
    pub next_payment_date: Option<DateTime>,
    
    #[serde(rename = "PaidDate", skip_serializing_if = "Option::is_none")]
    pub paid_date: Option<DateTime>,
    
    #[serde(rename = "Stage", skip_serializing_if = "Option::is_none")]
    pub stage: Option<SelfInvoiceActionStageTypeView>,
    
}