
use crate::models::ActionSearchStatusTypeView; 
use crate::models::ActionTypeView; 
use crate::models::DateTime; 
use crate::models::Guid; 
use crate::models::RotRutSearchFilterTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct SearchView {
    
    #[serde(rename = "AttestedDateFrom", skip_serializing_if = "Option::is_none")]
    pub attested_date_from: Option<DateTime>,
    
    #[serde(rename = "AttestedDateTo", skip_serializing_if = "Option::is_none")]
    pub attested_date_to: Option<DateTime>,
    
    #[serde(rename = "ClosedDateFrom", skip_serializing_if = "Option::is_none")]
    pub closed_date_from: Option<DateTime>,
    
    #[serde(rename = "ClosedDateTo", skip_serializing_if = "Option::is_none")]
    pub closed_date_to: Option<DateTime>,
    
    #[serde(rename = "CostCenter", skip_serializing_if = "Option::is_none")]
    pub cost_center: Option<String>,
    
    #[serde(rename = "CreatedDateFrom", skip_serializing_if = "Option::is_none")]
    pub created_date_from: Option<DateTime>,
    
    #[serde(rename = "CreatedDateTo", skip_serializing_if = "Option::is_none")]
    pub created_date_to: Option<DateTime>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "DebtorPublicIds", skip_serializing_if = "Vec::is_empty", default)]
    pub debtor_public_ids: Vec<Guid>,
    
    #[serde(rename = "DueDateFrom", skip_serializing_if = "Option::is_none")]
    pub due_date_from: Option<DateTime>,
    
    #[serde(rename = "DueDateTo", skip_serializing_if = "Option::is_none")]
    pub due_date_to: Option<DateTime>,
    
    #[serde(rename = "InvoiceDateFrom", skip_serializing_if = "Option::is_none")]
    pub invoice_date_from: Option<DateTime>,
    
    #[serde(rename = "InvoiceDateTo", skip_serializing_if = "Option::is_none")]
    pub invoice_date_to: Option<DateTime>,
    
    #[serde(rename = "PeriodDateFrom", skip_serializing_if = "Option::is_none")]
    pub period_date_from: Option<DateTime>,
    
    #[serde(rename = "PeriodDateTo", skip_serializing_if = "Option::is_none")]
    pub period_date_to: Option<DateTime>,
    
    #[serde(rename = "ProductPublicIds", skip_serializing_if = "Vec::is_empty", default)]
    pub product_public_ids: Vec<Guid>,
    
    #[serde(rename = "Project", skip_serializing_if = "Option::is_none")]
    pub project: Option<String>,
    
    #[serde(rename = "RotRut", skip_serializing_if = "Option::is_none")]
    pub rot_rut: Option<RotRutSearchFilterTypeView>,
    
    #[serde(rename = "SearchValue", skip_serializing_if = "Option::is_none")]
    pub search_value: Option<String>,
    
    #[serde(rename = "Status", skip_serializing_if = "Vec::is_empty", default)]
    pub status: Vec<ActionSearchStatusTypeView>,
    
    #[serde(rename = "Types", skip_serializing_if = "Vec::is_empty", default)]
    pub types: Vec<ActionTypeView>,
    
}