
use crate::models::AmountView; 
use crate::models::DateTime; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct ReminderInvoiceActionSubView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "CurrentFeeAmount", skip_serializing_if = "Option::is_none")]
    pub current_fee_amount: Option<AmountView>,
    
    #[serde(rename = "LastReminderDate", skip_serializing_if = "Option::is_none")]
    pub last_reminder_date: Option<DateTime>,
    
    #[serde(rename = "LastReminderDueDate", skip_serializing_if = "Option::is_none")]
    pub last_reminder_due_date: Option<DateTime>,
    
    #[serde(rename = "SourceActionPublicId", skip_serializing_if = "Option::is_none")]
    pub source_action_public_id: Option<String>,
    
    #[serde(rename = "SourceCurrentAmount", skip_serializing_if = "Option::is_none")]
    pub source_current_amount: Option<AmountView>,
    
    #[serde(rename = "SourceOriginalAmount", skip_serializing_if = "Option::is_none")]
    pub source_original_amount: Option<AmountView>,
    
}