
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::RegisterPaymentOverShootingAmountHandlingTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct RegisterPaymentView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "Amount", skip_serializing_if = "Option::is_none")]
    pub amount: Option<AmountView>,
    
    #[serde(rename = "Comment", skip_serializing_if = "Option::is_none")]
    pub comment: Option<String>,
    
    #[serde(rename = "Date", skip_serializing_if = "Option::is_none")]
    pub date: Option<DateTime>,
    
    #[serde(rename = "OvershootingAmountHandling", skip_serializing_if = "Option::is_none")]
    pub overshooting_amount_handling: Option<RegisterPaymentOverShootingAmountHandlingTypeView>,
    
    #[serde(rename = "PaymentMeanCode", skip_serializing_if = "Option::is_none")]
    pub payment_mean_code: Option<String>,
    
    #[serde(rename = "PaymentReferenceText", skip_serializing_if = "Option::is_none")]
    pub payment_reference_text: Option<String>,
    
    #[serde(rename = "WriteOff", skip_serializing_if = "Option::is_none")]
    pub write_off: Option<AmountView>,
    
    #[serde(rename = "WriteOffVat", skip_serializing_if = "Option::is_none")]
    pub write_off_vat: Option<f64>,
    
}