
use crate::models::DateTime; 
use crate::models::Guid; 
use crate::models::ProjectStatusTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct ProjectView {
    
    #[serde(rename = "Comments", skip_serializing_if = "Option::is_none")]
    pub comments: Option<String>,
    
    #[serde(rename = "ContactPerson", skip_serializing_if = "Option::is_none")]
    pub contact_person: Option<String>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "Description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    
    #[serde(rename = "EndDate", skip_serializing_if = "Option::is_none")]
    pub end_date: Option<DateTime>,
    
    #[serde(rename = "ProjectLeader", skip_serializing_if = "Option::is_none")]
    pub project_leader: Option<String>,
    
    #[serde(rename = "ProjectNumber", skip_serializing_if = "Option::is_none")]
    pub project_number: Option<String>,
    
    #[serde(rename = "StartDate", skip_serializing_if = "Option::is_none")]
    pub start_date: Option<DateTime>,
    
    #[serde(rename = "Status", skip_serializing_if = "Option::is_none")]
    pub status: Option<ProjectStatusTypeView>,
    
}