
use crate::models::Guid; 
use crate::models::ProductTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct ProductView {
    
    #[serde(rename = "ArticleNumber", skip_serializing_if = "Option::is_none")]
    pub article_number: Option<String>,
    
    #[serde(rename = "BookKeepingAccount", skip_serializing_if = "Option::is_none")]
    pub book_keeping_account: Option<i64>,
    
    #[serde(rename = "BookKeepingPurchaseAccount", skip_serializing_if = "Option::is_none")]
    pub book_keeping_purchase_account: Option<i64>,
    
    #[serde(rename = "BookKeepingPurchaseVATAccount", skip_serializing_if = "Option::is_none")]
    pub book_keeping_purchase_vat_account: Option<i64>,
    
    #[serde(rename = "BookKeepingSalesEUAccount", skip_serializing_if = "Option::is_none")]
    pub book_keeping_sales_eu_account: Option<i64>,
    
    #[serde(rename = "BookKeepingSalesEUVATAccount", skip_serializing_if = "Option::is_none")]
    pub book_keeping_sales_euvat_account: Option<i64>,
    
    #[serde(rename = "BookKeepingSalesNonEUAccount", skip_serializing_if = "Option::is_none")]
    pub book_keeping_sales_non_eu_account: Option<i64>,
    
    #[serde(rename = "BookKeepingVATAccount", skip_serializing_if = "Option::is_none")]
    pub book_keeping_vat_account: Option<i64>,
    
    #[serde(rename = "ConfigurationCode", skip_serializing_if = "Option::is_none")]
    pub configuration_code: Option<String>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "Description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    
    #[serde(rename = "IsActive", skip_serializing_if = "Option::is_none")]
    pub is_active: Option<bool>,
    
    #[serde(rename = "ProductExternalId", skip_serializing_if = "Option::is_none")]
    pub product_external_id: Option<String>,
    
    #[serde(rename = "ProductPublicId", skip_serializing_if = "Option::is_none")]
    pub product_public_id: Option<Guid>,
    
    #[serde(rename = "ProductType", skip_serializing_if = "Option::is_none")]
    pub product_type: Option<ProductTypeView>,
    
    #[serde(rename = "UnitPrice", skip_serializing_if = "Option::is_none")]
    pub unit_price: Option<f64>,
    
    #[serde(rename = "Units", skip_serializing_if = "Option::is_none")]
    pub units: Option<String>,
    
    #[serde(rename = "VAT", skip_serializing_if = "Option::is_none")]
    pub vat: Option<f64>,
    
}