
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct InvoiceTextTemplateView {
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "Description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    
    #[serde(rename = "InvoiceTextTemplatePublicId", skip_serializing_if = "Option::is_none")]
    pub invoice_text_template_public_id: Option<Guid>,
    
}