
use crate::models::ActionTypeView; 
use crate::models::AmountView; 
use crate::models::AutogiroWithdrawalView; 
use crate::models::CreditCardWithdrawalView; 
use crate::models::CreditingInvoiceView; 
use crate::models::DateTime; 
use crate::models::DebtCollectionDetailsView; 
use crate::models::DebtorView; 
use crate::models::DeliveryAddressOverrideView; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::FileView; 
use crate::models::Guid; 
use crate::models::InterestTypeView; 
use crate::models::InvoiceActionAttachmentView; 
use crate::models::InvoiceActionEventView; 
use crate::models::InvoiceActionInvoiceView; 
use crate::models::InvoiceActionRecordView; 
use crate::models::InvoiceActionStateView; 
use crate::models::LanguageTypeView; 
use crate::models::PaymentOverrideView; 
use crate::models::ReminderInvoiceDetailsView; 
use crate::models::ReverseVATDetailsView; 
use crate::models::RotRutDetailsView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct InvoiceActionView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "ActionType", skip_serializing_if = "Option::is_none")]
    pub action_type: Option<ActionTypeView>,
    
    #[serde(rename = "Appendixes", skip_serializing_if = "Vec::is_empty", default)]
    pub appendixes: Vec<FileView>,
    
    #[serde(rename = "Attachments", skip_serializing_if = "Vec::is_empty", default)]
    pub attachments: Vec<InvoiceActionAttachmentView>,
    
    #[serde(rename = "Autogiro", skip_serializing_if = "Option::is_none")]
    pub autogiro: Option<AutogiroWithdrawalView>,
    
    #[serde(rename = "AwaitingPaymentTransferAmount", skip_serializing_if = "Option::is_none")]
    pub awaiting_payment_transfer_amount: Option<AmountView>,
    
    #[serde(rename = "CanCancelSalesRequest", skip_serializing_if = "Option::is_none")]
    pub can_cancel_sales_request: Option<bool>,
    
    #[serde(rename = "CanCreateAutogiroWithdrawal", skip_serializing_if = "Option::is_none")]
    pub can_create_autogiro_withdrawal: Option<bool>,
    
    #[serde(rename = "CanCreateCreditInvoice", skip_serializing_if = "Option::is_none")]
    pub can_create_credit_invoice: Option<bool>,
    
    #[serde(rename = "CanCreateInterestInvoice", skip_serializing_if = "Option::is_none")]
    pub can_create_interest_invoice: Option<bool>,
    
    #[serde(rename = "CanDispute", skip_serializing_if = "Option::is_none")]
    pub can_dispute: Option<bool>,
    
    #[serde(rename = "CanMakeManual", skip_serializing_if = "Option::is_none")]
    pub can_make_manual: Option<bool>,
    
    #[serde(rename = "CanPause", skip_serializing_if = "Option::is_none")]
    pub can_pause: Option<bool>,
    
    #[serde(rename = "CanPostpone", skip_serializing_if = "Option::is_none")]
    pub can_postpone: Option<bool>,
    
    #[serde(rename = "CanRegisterPayment", skip_serializing_if = "Option::is_none")]
    pub can_register_payment: Option<bool>,
    
    #[serde(rename = "CanResendManualInvoice", skip_serializing_if = "Option::is_none")]
    pub can_resend_manual_invoice: Option<bool>,
    
    #[serde(rename = "CanResume", skip_serializing_if = "Option::is_none")]
    pub can_resume: Option<bool>,
    
    #[serde(rename = "CanSell", skip_serializing_if = "Option::is_none")]
    pub can_sell: Option<bool>,
    
    #[serde(rename = "CanSendManualInvoice", skip_serializing_if = "Option::is_none")]
    pub can_send_manual_invoice: Option<bool>,
    
    #[serde(rename = "CanSendManualReminderInvoice", skip_serializing_if = "Option::is_none")]
    pub can_send_manual_reminder_invoice: Option<bool>,
    
    #[serde(rename = "CanSendToDebtCollection", skip_serializing_if = "Option::is_none")]
    pub can_send_to_debt_collection: Option<bool>,
    
    #[serde(rename = "CanUnDispute", skip_serializing_if = "Option::is_none")]
    pub can_un_dispute: Option<bool>,
    
    #[serde(rename = "CentRoundingAmount", skip_serializing_if = "Option::is_none")]
    pub cent_rounding_amount: Option<AmountView>,
    
    #[serde(rename = "CommunicationLanguage", skip_serializing_if = "Option::is_none")]
    pub communication_language: Option<LanguageTypeView>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "CreditCard", skip_serializing_if = "Option::is_none")]
    pub credit_card: Option<CreditCardWithdrawalView>,
    
    #[serde(rename = "CreditedAmount", skip_serializing_if = "Option::is_none")]
    pub credited_amount: Option<AmountView>,
    
    #[serde(rename = "CreditingInvoice", skip_serializing_if = "Option::is_none")]
    pub crediting_invoice: Option<CreditingInvoiceView>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "CurrentAmount", skip_serializing_if = "Option::is_none")]
    pub current_amount: Option<AmountView>,
    
    #[serde(rename = "DebtCollectionActionPublicId", skip_serializing_if = "Option::is_none")]
    pub debt_collection_action_public_id: Option<String>,
    
    #[serde(rename = "DebtCollectionDetails", skip_serializing_if = "Option::is_none")]
    pub debt_collection_details: Option<DebtCollectionDetailsView>,
    
    #[serde(rename = "Debtor", skip_serializing_if = "Option::is_none")]
    pub debtor: Option<DebtorView>,
    
    #[serde(rename = "DeliveryAddressOverride", skip_serializing_if = "Option::is_none")]
    pub delivery_address_override: Option<DeliveryAddressOverrideView>,
    
    #[serde(rename = "DeliveryDate", skip_serializing_if = "Option::is_none")]
    pub delivery_date: Option<DateTime>,
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "DueDate", skip_serializing_if = "Option::is_none")]
    pub due_date: Option<DateTime>,
    
    #[serde(rename = "Events", skip_serializing_if = "Vec::is_empty", default)]
    pub events: Vec<InvoiceActionEventView>,
    
    #[serde(rename = "ExternalReference", skip_serializing_if = "Option::is_none")]
    pub external_reference: Option<String>,
    
    #[serde(rename = "FreightFee", skip_serializing_if = "Option::is_none")]
    pub freight_fee: Option<AmountView>,
    
    #[serde(rename = "InterestAmount", skip_serializing_if = "Option::is_none")]
    pub interest_amount: Option<AmountView>,
    
    #[serde(rename = "InterestPercentage", skip_serializing_if = "Option::is_none")]
    pub interest_percentage: Option<f64>,
    
    #[serde(rename = "InterestStartInDaysAfterDueDate", skip_serializing_if = "Option::is_none")]
    pub interest_start_in_days_after_due_date: Option<i64>,
    
    #[serde(rename = "InterestType", skip_serializing_if = "Option::is_none")]
    pub interest_type: Option<InterestTypeView>,
    
    #[serde(rename = "InvoiceDate", skip_serializing_if = "Option::is_none")]
    pub invoice_date: Option<DateTime>,
    
    #[serde(rename = "InvoiceFee", skip_serializing_if = "Option::is_none")]
    pub invoice_fee: Option<AmountView>,
    
    #[serde(rename = "InvoiceNumber", skip_serializing_if = "Option::is_none")]
    pub invoice_number: Option<String>,
    
    #[serde(rename = "InvoicedAmount", skip_serializing_if = "Option::is_none")]
    pub invoiced_amount: Option<AmountView>,
    
    #[serde(rename = "Invoices", skip_serializing_if = "Vec::is_empty", default)]
    pub invoices: Vec<InvoiceActionInvoiceView>,
    
    #[serde(rename = "Message", skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    
    #[serde(rename = "OurReference", skip_serializing_if = "Option::is_none")]
    pub our_reference: Option<String>,
    
    #[serde(rename = "PaidAmount", skip_serializing_if = "Option::is_none")]
    pub paid_amount: Option<AmountView>,
    
    #[serde(rename = "PaymentOverride", skip_serializing_if = "Option::is_none")]
    pub payment_override: Option<PaymentOverrideView>,
    
    #[serde(rename = "PaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "ReasonForHigherInterest", skip_serializing_if = "Option::is_none")]
    pub reason_for_higher_interest: Option<String>,
    
    #[serde(rename = "Records", skip_serializing_if = "Vec::is_empty", default)]
    pub records: Vec<InvoiceActionRecordView>,
    
    #[serde(rename = "ReminderInvoiceActionPublicId", skip_serializing_if = "Option::is_none")]
    pub reminder_invoice_action_public_id: Option<String>,
    
    #[serde(rename = "ReminderInvoiceDetails", skip_serializing_if = "Option::is_none")]
    pub reminder_invoice_details: Option<ReminderInvoiceDetailsView>,
    
    #[serde(rename = "ReverseVATDetails", skip_serializing_if = "Option::is_none")]
    pub reverse_vat_details: Option<ReverseVATDetailsView>,
    
    #[serde(rename = "RotRutDeductionAmount", skip_serializing_if = "Option::is_none")]
    pub rot_rut_deduction_amount: Option<AmountView>,
    
    #[serde(rename = "RotRutDetails", skip_serializing_if = "Option::is_none")]
    pub rot_rut_details: Option<RotRutDetailsView>,
    
    #[serde(rename = "SendByMailIfEmailNotViewedInDays", skip_serializing_if = "Option::is_none")]
    pub send_by_mail_if_email_not_viewed_in_days: Option<i64>,
    
    #[serde(rename = "State", skip_serializing_if = "Option::is_none")]
    pub state: Option<InvoiceActionStateView>,
    
    #[serde(rename = "TotalVATAmount", skip_serializing_if = "Option::is_none")]
    pub total_vat_amount: Option<AmountView>,
    
    #[serde(rename = "VatIsIncluded", skip_serializing_if = "Option::is_none")]
    pub vat_is_included: Option<bool>,
    
    #[serde(rename = "WriteOffAmount", skip_serializing_if = "Option::is_none")]
    pub write_off_amount: Option<AmountView>,
    
    #[serde(rename = "YourReference", skip_serializing_if = "Option::is_none")]
    pub your_reference: Option<String>,
    
}