
use crate::models::ActionTypeView; 
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::DeliveryStatusTypeView; 
use crate::models::FileView; 
use crate::models::Guid; 
use crate::models::InstallmentPlanActionStageTypeView; 
use crate::models::LanguageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct InstallmentPlanActionSubView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "ActionType", skip_serializing_if = "Option::is_none")]
    pub action_type: Option<ActionTypeView>,
    
    #[serde(rename = "AttestedDate", skip_serializing_if = "Option::is_none")]
    pub attested_date: Option<DateTime>,
    
    #[serde(rename = "ClosedDate", skip_serializing_if = "Option::is_none")]
    pub closed_date: Option<DateTime>,
    
    #[serde(rename = "CommunicationLanguage", skip_serializing_if = "Option::is_none")]
    pub communication_language: Option<LanguageTypeView>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "CreditorName", skip_serializing_if = "Option::is_none")]
    pub creditor_name: Option<String>,
    
    #[serde(rename = "CreditorOrgNo", skip_serializing_if = "Option::is_none")]
    pub creditor_org_no: Option<String>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "CurrentAmount", skip_serializing_if = "Option::is_none")]
    pub current_amount: Option<AmountView>,
    
    #[serde(rename = "DebtorName", skip_serializing_if = "Option::is_none")]
    pub debtor_name: Option<String>,
    
    #[serde(rename = "DebtorOrgNo", skip_serializing_if = "Option::is_none")]
    pub debtor_org_no: Option<String>,
    
    #[serde(rename = "DebtorPublicId", skip_serializing_if = "Option::is_none")]
    pub debtor_public_id: Option<Guid>,
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "DeliveryStatus", skip_serializing_if = "Option::is_none")]
    pub delivery_status: Option<DeliveryStatusTypeView>,
    
    #[serde(rename = "Files", skip_serializing_if = "Vec::is_empty", default)]
    pub files: Vec<FileView>,
    
    #[serde(rename = "InterestPercentage", skip_serializing_if = "Option::is_none")]
    pub interest_percentage: Option<f64>,
    
    #[serde(rename = "InvoiceNumbers", skip_serializing_if = "Vec::is_empty", default)]
    pub invoice_numbers: Vec<String>,
    
    #[serde(rename = "InvoicedAmount", skip_serializing_if = "Option::is_none")]
    pub invoiced_amount: Option<AmountView>,
    
    #[serde(rename = "IsCommented", skip_serializing_if = "Option::is_none")]
    pub is_commented: Option<bool>,
    
    #[serde(rename = "IsDisputed", skip_serializing_if = "Option::is_none")]
    pub is_disputed: Option<bool>,
    
    #[serde(rename = "IsPaused", skip_serializing_if = "Option::is_none")]
    pub is_paused: Option<bool>,
    
    #[serde(rename = "NextEvent", skip_serializing_if = "Option::is_none")]
    pub next_event: Option<String>,
    
    #[serde(rename = "NextEventDate", skip_serializing_if = "Option::is_none")]
    pub next_event_date: Option<DateTime>,
    
    #[serde(rename = "OCRs", skip_serializing_if = "Vec::is_empty", default)]
    pub oc_rs: Vec<String>,
    
    #[serde(rename = "OriginalDueDate", skip_serializing_if = "Option::is_none")]
    pub original_due_date: Option<DateTime>,
    
    #[serde(rename = "OriginalInvoiceDate", skip_serializing_if = "Option::is_none")]
    pub original_invoice_date: Option<DateTime>,
    
    #[serde(rename = "OriginalInvoiceNumber", skip_serializing_if = "Option::is_none")]
    pub original_invoice_number: Option<String>,
    
    #[serde(rename = "PaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "Stage", skip_serializing_if = "Option::is_none")]
    pub stage: Option<InstallmentPlanActionStageTypeView>,
    
}