use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum EventTypeView {
    
    AppendixAdded,
    AppendixCleared,
    Archived,
    Attested,
    AutogiroApprovalAdded,
    AutogiroApprovalChanged,
    AutogiroApprovalRemoved,
    AutogiroCancelledWithdrawal,
    AutogiroPaymentPostponed,
    AutogiroWithdrawal,
    AwaitingInvoiceSaleRequestResponse,
    AwatingPaymentAcknowledgment,
    Cancelled,
    ChangedOwner,
    CommentedByCreditor,
    CommentedByDebtor,
    Completed,
    Created,
    CreditCardAdded,
    CreditCardCancelledWithdrawal,
    CreditCardRemoved,
    CreditCardWithdrawal,
    Credited,
    CreditorCommentByAdmin,
    DebtCollectionDue,
    DebtCollectionSent,
    Disputed,
    EInvoiceEvent,
    EInvoiceRegistered,
    EInvoiceUnregistered,
    EInvoiceWasRejected,
    EmailEvent,
    ForeignMakeReadyForLocalRepresentative,
    ForeignSentToLocalRepresentative,
    FuturePayment,
    InstallmentPlanPartialInvoiceSent,
    InstallmentPlanRequested,
    InvoiceDue,
    InvoiceSaleRequestCancelled,
    InvoiceSaleRequestDenied,
    InvoiceSaleRequested,
    InvoiceSent,
    InvoiceSold,
    LongTermSurveilance,
    MadeManual,
    ManagedForBailiffEnforcementRegistration,
    ManagedForBailiffRegistration,
    ManagedForReturnToDebtCollection,
    MessageSendToSocialWelfare,
    Moved,
    OriginalInvoiceDue,
    OverPayment,
    Paid,
    PartialInvoiceDue,
    Paused,
    PaymentCancelled,
    PaymentRefunded,
    PaymentSent,
    PaymentWillBeMade,
    PublicCommentByAdmin,
    ReadByUser,
    ReminderDue,
    ReminderInvoiceSent,
    ReminderSent,
    Resumed,
    SentToBailiff,
    SentToBailiffExecution,
    SentToDebtCollection,
    SmsEvent,
    SmsSent,
    SmsWillBeSent,
    SupplementSentToKFM,
    UnAttested,
    UnDisputed,
    Unknown,
    Updated,
    VerdictNumberObtained,
    WillBeManagedForBailiffRegistration,
    WillBeSentToDebtCollection,
    WillSendDebtCollectionInvoice,
    WillSendInvoice,
    WillSendLatePaymentInvoice,
    WillSendPartialInvoice,
    WillSendReminderInvoice,
    WrittenOff,

}


impl fmt::Display for EventTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}