
use crate::models::DateTime; 
use crate::models::EventTypeView; 
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct DebtorEventView {
    
    #[serde(rename = "Content", skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
    
    #[serde(rename = "EventBy", skip_serializing_if = "Option::is_none")]
    pub event_by: Option<String>,
    
    #[serde(rename = "EventDate", skip_serializing_if = "Option::is_none")]
    pub event_date: Option<DateTime>,
    
    #[serde(rename = "EventPublicId", skip_serializing_if = "Option::is_none")]
    pub event_public_id: Option<Guid>,
    
    #[serde(rename = "EventType", skip_serializing_if = "Option::is_none")]
    pub event_type: Option<EventTypeView>,
    
    #[serde(rename = "HasOccured", skip_serializing_if = "Option::is_none")]
    pub has_occured: Option<bool>,
    
    #[serde(rename = "IsPublic", skip_serializing_if = "Option::is_none")]
    pub is_public: Option<bool>,
    
    #[serde(rename = "Reference", skip_serializing_if = "Option::is_none")]
    pub reference: Option<String>,
    
    #[serde(rename = "Title", skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    
}