
use crate::models::DebtCollectionActionLevelTypeView; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::InterestTypeView; 
use crate::models::LanguageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct DebtorDefaultActionConfigView {
    
    #[serde(rename = "ActivateDefaultActionConfigOverride", skip_serializing_if = "Option::is_none")]
    pub activate_default_action_config_override: Option<bool>,
    
    #[serde(rename = "CommunicationLanguage", skip_serializing_if = "Option::is_none")]
    pub communication_language: Option<LanguageTypeView>,
    
    #[serde(rename = "CurrencyCode", skip_serializing_if = "Option::is_none")]
    pub currency_code: Option<String>,
    
    #[serde(rename = "DebtCollectionPaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub debt_collection_payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "IncludePdfInEmail", skip_serializing_if = "Option::is_none")]
    pub include_pdf_in_email: Option<bool>,
    
    #[serde(rename = "InterestPercentage", skip_serializing_if = "Option::is_none")]
    pub interest_percentage: Option<f64>,
    
    #[serde(rename = "InterestStartInDaysAfterDueDate", skip_serializing_if = "Option::is_none")]
    pub interest_start_in_days_after_due_date: Option<i64>,
    
    #[serde(rename = "InterestType", skip_serializing_if = "Option::is_none")]
    pub interest_type: Option<InterestTypeView>,
    
    #[serde(rename = "InvoiceComment", skip_serializing_if = "Option::is_none")]
    pub invoice_comment: Option<String>,
    
    #[serde(rename = "InvoiceFee", skip_serializing_if = "Option::is_none")]
    pub invoice_fee: Option<f64>,
    
    #[serde(rename = "InvoicePaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub invoice_payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "NumberOfReminders", skip_serializing_if = "Option::is_none")]
    pub number_of_reminders: Option<i64>,
    
    #[serde(rename = "OurReference", skip_serializing_if = "Option::is_none")]
    pub our_reference: Option<String>,
    
    #[serde(rename = "PaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "ReasonForHigherInterest", skip_serializing_if = "Option::is_none")]
    pub reason_for_higher_interest: Option<String>,
    
    #[serde(rename = "ReminderInvoiceFee", skip_serializing_if = "Option::is_none")]
    pub reminder_invoice_fee: Option<f64>,
    
    #[serde(rename = "ReminderInvoicePaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub reminder_invoice_payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "SendByMailIfEmailNotViewedInDays", skip_serializing_if = "Option::is_none")]
    pub send_by_mail_if_email_not_viewed_in_days: Option<i64>,
    
    #[serde(rename = "SendByMailIfEmailNotViewedInDaysEnabled", skip_serializing_if = "Option::is_none")]
    pub send_by_mail_if_email_not_viewed_in_days_enabled: Option<bool>,
    
    #[serde(rename = "SendInvoiceToDebtCollection", skip_serializing_if = "Option::is_none")]
    pub send_invoice_to_debt_collection: Option<bool>,
    
    #[serde(rename = "SendInvoiceToDebtCollectionAfterDays", skip_serializing_if = "Option::is_none")]
    pub send_invoice_to_debt_collection_after_days: Option<i64>,
    
    #[serde(rename = "SendReminderInvoice", skip_serializing_if = "Option::is_none")]
    pub send_reminder_invoice: Option<bool>,
    
    #[serde(rename = "SendReminderInvoiceDaysAfterDueDate", skip_serializing_if = "Option::is_none")]
    pub send_reminder_invoice_days_after_due_date: Option<i64>,
    
    #[serde(rename = "StartDebtCollectionActionLevel", skip_serializing_if = "Option::is_none")]
    pub start_debt_collection_action_level: Option<DebtCollectionActionLevelTypeView>,
    
}