
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::DebtCollectionActionLevelTypeView; 
use crate::models::DeliveryAddressOverrideView; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::FileView; 
use crate::models::Guid; 
use crate::models::InterestTypeView; 
use crate::models::LanguageTypeView; 
use crate::models::PaymentOverrideView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct DebtCollectionEntryView {
    
    #[serde(rename = "CommunicationLanguage", skip_serializing_if = "Option::is_none")]
    pub communication_language: Option<LanguageTypeView>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "DebtorPublicId", skip_serializing_if = "Option::is_none")]
    pub debtor_public_id: Option<Guid>,
    
    #[serde(rename = "DeliveryAddressOverride", skip_serializing_if = "Option::is_none")]
    pub delivery_address_override: Option<DeliveryAddressOverrideView>,
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "EndDebtCollectionActionLevel", skip_serializing_if = "Option::is_none")]
    pub end_debt_collection_action_level: Option<DebtCollectionActionLevelTypeView>,
    
    #[serde(rename = "Eviction", skip_serializing_if = "Option::is_none")]
    pub eviction: Option<bool>,
    
    #[serde(rename = "InformSocialWelfare", skip_serializing_if = "Option::is_none")]
    pub inform_social_welfare: Option<bool>,
    
    #[serde(rename = "InterestPercentage", skip_serializing_if = "Option::is_none")]
    pub interest_percentage: Option<f64>,
    
    #[serde(rename = "InterestStartInDaysAfterDueDate", skip_serializing_if = "Option::is_none")]
    pub interest_start_in_days_after_due_date: Option<i64>,
    
    #[serde(rename = "InterestType", skip_serializing_if = "Option::is_none")]
    pub interest_type: Option<InterestTypeView>,
    
    #[serde(rename = "NumberOfReminders", skip_serializing_if = "Option::is_none")]
    pub number_of_reminders: Option<i64>,
    
    #[serde(rename = "OriginalDueDate", skip_serializing_if = "Option::is_none")]
    pub original_due_date: Option<DateTime>,
    
    #[serde(rename = "OriginalInvoiceDate", skip_serializing_if = "Option::is_none")]
    pub original_invoice_date: Option<DateTime>,
    
    #[serde(rename = "OriginalInvoiceFile", skip_serializing_if = "Option::is_none")]
    pub original_invoice_file: Option<FileView>,
    
    #[serde(rename = "OriginalInvoiceNumber", skip_serializing_if = "Option::is_none")]
    pub original_invoice_number: Option<String>,
    
    #[serde(rename = "OurReference", skip_serializing_if = "Option::is_none")]
    pub our_reference: Option<String>,
    
    #[serde(rename = "PaymentOverride", skip_serializing_if = "Option::is_none")]
    pub payment_override: Option<PaymentOverrideView>,
    
    #[serde(rename = "PaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "ReasonDescription", skip_serializing_if = "Option::is_none")]
    pub reason_description: Option<String>,
    
    #[serde(rename = "ReasonForHigherInterest", skip_serializing_if = "Option::is_none")]
    pub reason_for_higher_interest: Option<String>,
    
    #[serde(rename = "StartDebtCollectionActionLevel", skip_serializing_if = "Option::is_none")]
    pub start_debt_collection_action_level: Option<DebtCollectionActionLevelTypeView>,
    
    #[serde(rename = "Value", skip_serializing_if = "Option::is_none")]
    pub value: Option<AmountView>,
    
    #[serde(rename = "YourReference", skip_serializing_if = "Option::is_none")]
    pub your_reference: Option<String>,
    
}