
use crate::models::DebtCollectionActionLevelTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct DebtCollectionDetailsView {
    
    #[serde(rename = "DaysDelayAfterDueDate", skip_serializing_if = "Option::is_none")]
    pub days_delay_after_due_date: Option<i64>,
    
    #[serde(rename = "EndDebtCollectionActionLevel", skip_serializing_if = "Option::is_none")]
    pub end_debt_collection_action_level: Option<DebtCollectionActionLevelTypeView>,
    
    #[serde(rename = "Eviction", skip_serializing_if = "Option::is_none")]
    pub eviction: Option<bool>,
    
    #[serde(rename = "InformSocialWelfare", skip_serializing_if = "Option::is_none")]
    pub inform_social_welfare: Option<bool>,
    
    #[serde(rename = "NumberOfReminders", skip_serializing_if = "Option::is_none")]
    pub number_of_reminders: Option<i64>,
    
    #[serde(rename = "PaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "SendToDebtCollection", skip_serializing_if = "Option::is_none")]
    pub send_to_debt_collection: Option<bool>,
    
    #[serde(rename = "StartDebtCollectionActionLevel", skip_serializing_if = "Option::is_none")]
    pub start_debt_collection_action_level: Option<DebtCollectionActionLevelTypeView>,
    
}