
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct CreditorShareView {
    
    #[serde(rename = "CanAttestInvoice", skip_serializing_if = "Option::is_none")]
    pub can_attest_invoice: Option<bool>,
    
    #[serde(rename = "CanAttestSupplierInvoice", skip_serializing_if = "Option::is_none")]
    pub can_attest_supplier_invoice: Option<bool>,
    
    #[serde(rename = "CanManageInvoicePayments", skip_serializing_if = "Option::is_none")]
    pub can_manage_invoice_payments: Option<bool>,
    
    #[serde(rename = "CanPaySupplierInvoice", skip_serializing_if = "Option::is_none")]
    pub can_pay_supplier_invoice: Option<bool>,
    
    #[serde(rename = "CanReadBookkeeping", skip_serializing_if = "Option::is_none")]
    pub can_read_bookkeeping: Option<bool>,
    
    #[serde(rename = "CanReadSettings", skip_serializing_if = "Option::is_none")]
    pub can_read_settings: Option<bool>,
    
    #[serde(rename = "CanWriteCreditor", skip_serializing_if = "Option::is_none")]
    pub can_write_creditor: Option<bool>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "SharePublicId", skip_serializing_if = "Option::is_none")]
    pub share_public_id: Option<Guid>,
    
    #[serde(rename = "SharedWithUserName", skip_serializing_if = "Option::is_none")]
    pub shared_with_user_name: Option<String>,
    
}