
use crate::models::CreditorKycFormView; 
use crate::models::CreditorKycStateTypeView; 
use crate::models::DateTime; 
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct CreditorKycView {
    
    #[serde(rename = "CreditorKycForm", skip_serializing_if = "Option::is_none")]
    pub creditor_kyc_form: Option<CreditorKycFormView>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "MobileBankIdTokenUsedForSign", skip_serializing_if = "Option::is_none")]
    pub mobile_bank_id_token_used_for_sign: Option<Guid>,
    
    #[serde(rename = "SignedByName", skip_serializing_if = "Option::is_none")]
    pub signed_by_name: Option<String>,
    
    #[serde(rename = "SignedBySSN", skip_serializing_if = "Option::is_none")]
    pub signed_by_ssn: Option<String>,
    
    #[serde(rename = "SignedDate", skip_serializing_if = "Option::is_none")]
    pub signed_date: Option<DateTime>,
    
    #[serde(rename = "State", skip_serializing_if = "Option::is_none")]
    pub state: Option<CreditorKycStateTypeView>,
    
}