
use crate::models::ActionTypeView; 
use crate::models::AmountView; 
use crate::models::CreditCardPaymentStatusTypeView; 
use crate::models::DateTime; 
use crate::models::Guid; 
use crate::models::LanguageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct CreditCardPaymentView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "ActionType", skip_serializing_if = "Option::is_none")]
    pub action_type: Option<ActionTypeView>,
    
    #[serde(rename = "Amount", skip_serializing_if = "Option::is_none")]
    pub amount: Option<AmountView>,
    
    #[serde(rename = "Comment", skip_serializing_if = "Option::is_none")]
    pub comment: Option<String>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "FailureUrl", skip_serializing_if = "Option::is_none")]
    pub failure_url: Option<String>,
    
    #[serde(rename = "Funding", skip_serializing_if = "Option::is_none")]
    pub funding: Option<String>,
    
    #[serde(rename = "Language", skip_serializing_if = "Option::is_none")]
    pub language: Option<LanguageTypeView>,
    
    #[serde(rename = "PaymentDate", skip_serializing_if = "Option::is_none")]
    pub payment_date: Option<DateTime>,
    
    #[serde(rename = "PaymentPublicId", skip_serializing_if = "Option::is_none")]
    pub payment_public_id: Option<Guid>,
    
    #[serde(rename = "PaymentWindowUrl", skip_serializing_if = "Option::is_none")]
    pub payment_window_url: Option<String>,
    
    #[serde(rename = "Status", skip_serializing_if = "Option::is_none")]
    pub status: Option<CreditCardPaymentStatusTypeView>,
    
    #[serde(rename = "SuccessUrl", skip_serializing_if = "Option::is_none")]
    pub success_url: Option<String>,
    
}