
use crate::models::Guid; 
use crate::models::LanguageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct CreditCardAddIntentView {
    
    #[serde(rename = "DebtorPublicId", skip_serializing_if = "Option::is_none")]
    pub debtor_public_id: Option<Guid>,
    
    #[serde(rename = "FailureUrl", skip_serializing_if = "Option::is_none")]
    pub failure_url: Option<String>,
    
    #[serde(rename = "Language", skip_serializing_if = "Option::is_none")]
    pub language: Option<LanguageTypeView>,
    
    #[serde(rename = "SuccessUrl", skip_serializing_if = "Option::is_none")]
    pub success_url: Option<String>,
    
}