
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::Guid; 
use crate::models::RecurrenceIntervalTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct ContractInvoiceActionSubView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "Amount", skip_serializing_if = "Option::is_none")]
    pub amount: Option<AmountView>,
    
    #[serde(rename = "ContractNumber", skip_serializing_if = "Option::is_none")]
    pub contract_number: Option<String>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "CreditorName", skip_serializing_if = "Option::is_none")]
    pub creditor_name: Option<String>,
    
    #[serde(rename = "CreditorOrgNo", skip_serializing_if = "Option::is_none")]
    pub creditor_org_no: Option<String>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "DebtorName", skip_serializing_if = "Option::is_none")]
    pub debtor_name: Option<String>,
    
    #[serde(rename = "DebtorOrgNo", skip_serializing_if = "Option::is_none")]
    pub debtor_org_no: Option<String>,
    
    #[serde(rename = "DebtorPublicId", skip_serializing_if = "Option::is_none")]
    pub debtor_public_id: Option<Guid>,
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "End", skip_serializing_if = "Option::is_none")]
    pub end: Option<DateTime>,
    
    #[serde(rename = "IsPaused", skip_serializing_if = "Option::is_none")]
    pub is_paused: Option<bool>,
    
    #[serde(rename = "LastRunDate", skip_serializing_if = "Option::is_none")]
    pub last_run_date: Option<DateTime>,
    
    #[serde(rename = "NextRunDate", skip_serializing_if = "Option::is_none")]
    pub next_run_date: Option<DateTime>,
    
    #[serde(rename = "RecurrenceInterval", skip_serializing_if = "Option::is_none")]
    pub recurrence_interval: Option<RecurrenceIntervalTypeView>,
    
    #[serde(rename = "Start", skip_serializing_if = "Option::is_none")]
    pub start: Option<DateTime>,
    
}