
use crate::models::ContractInvoiceActionStageTypeView; 
use crate::models::DateTime; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct ContractInvoiceActionStateView {
    
    #[serde(rename = "CanPause", skip_serializing_if = "Option::is_none")]
    pub can_pause: Option<bool>,
    
    #[serde(rename = "CanResume", skip_serializing_if = "Option::is_none")]
    pub can_resume: Option<bool>,
    
    #[serde(rename = "IsPaused", skip_serializing_if = "Option::is_none")]
    pub is_paused: Option<bool>,
    
    #[serde(rename = "LastRunDate", skip_serializing_if = "Option::is_none")]
    pub last_run_date: Option<DateTime>,
    
    #[serde(rename = "NextRunDate", skip_serializing_if = "Option::is_none")]
    pub next_run_date: Option<DateTime>,
    
    #[serde(rename = "Stage", skip_serializing_if = "Option::is_none")]
    pub stage: Option<ContractInvoiceActionStageTypeView>,
    
    #[serde(rename = "UseDebtorBalance", skip_serializing_if = "Option::is_none")]
    pub use_debtor_balance: Option<bool>,
    
}