
use crate::models::AutogiroCompatibleTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct BankAccountView {
    
    #[serde(rename = "AccountNo", skip_serializing_if = "Option::is_none")]
    pub account_no: Option<String>,
    
    #[serde(rename = "AutogiroCompatible", skip_serializing_if = "Option::is_none")]
    pub autogiro_compatible: Option<AutogiroCompatibleTypeView>,
    
    #[serde(rename = "ClearingNo", skip_serializing_if = "Option::is_none")]
    pub clearing_no: Option<String>,
    
    #[serde(rename = "Iban", skip_serializing_if = "Option::is_none")]
    pub iban: Option<String>,
    
    #[serde(rename = "Number", skip_serializing_if = "Option::is_none")]
    pub number: Option<String>,
    
}