use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum BankAccountBankTypeView {
    
    FSPA,
    FSPASB,
    ICA,
    LFB,
    NB,
    OEB,
    SBAB,
    SEB,
    SHB,
    SKB,
    SYD,

}


impl fmt::Display for BankAccountBankTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}