
use crate::models::AccountingExportDateSelectionTypeView; 
use crate::models::AccountingExportFormatTypeView; 
use crate::models::AccountingRecordTypeView; 
use crate::models::DateTime; 
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct AccountingExportCreationView {
    
    #[serde(rename = "BookKeepingTypesFilter", skip_serializing_if = "Vec::is_empty", default)]
    pub book_keeping_types_filter: Vec<AccountingRecordTypeView>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "DateSelectionType", skip_serializing_if = "Option::is_none")]
    pub date_selection_type: Option<AccountingExportDateSelectionTypeView>,
    
    #[serde(rename = "Format", skip_serializing_if = "Option::is_none")]
    pub format: Option<AccountingExportFormatTypeView>,
    
    #[serde(rename = "From", skip_serializing_if = "Option::is_none")]
    pub from: Option<DateTime>,
    
    #[serde(rename = "To", skip_serializing_if = "Option::is_none")]
    pub to: Option<DateTime>,
    
}