mod client;
pub use client::Client;
mod models;
pub use models::*;

pub use chrono;
pub use http;
pub use eiktyrner;

mod analysis; // non generated tmpl
mod debenture; // non generated tmpl
mod files;


mod accounting;
mod authentication;
mod bank;
mod common;
mod contract_invoice;
mod cost_centers;
mod creditors;
mod debt_collection;
mod debtor_contracts;
mod debtors;
mod delivery;
mod invoice;
mod notifications;
mod payments;
mod products;
mod projects;
mod reconciliation_invoice;
mod search;
mod self_invoice;
mod users;


pub type Result<T> = std::result::Result<http::Response<T>, eiktyrner::Error>;

pub struct Param {
    value: Option<String>,
}


impl Param {

    fn value<T>(v: T) -> Self where T: std::fmt::Display {
        Self {
            value: Some(v.to_string()),
        }
    }
    
    fn opt<T>(v: Option<T>) -> Self where T: std::fmt::Display {
        Self {
            value: v.map(|v| v.to_string()),
        }
    }
}


pub struct PathAndQueryBuilder {
    buffer: String,
}

impl Default for PathAndQueryBuilder {
    fn default() -> Self {
	Self {
            buffer: String::new(),
        }
    }
}

impl PathAndQueryBuilder {

    pub fn url(&mut self, param: Param) -> &mut Self {
    
        if let Some(ref s) = param.value {
            if !self.buffer.is_empty() {
                self.buffer.push('/');
            }
            self.buffer.push_str(&urlencoding::encode(s));
        }
        
        self
    }
        
    pub fn query(&mut self, name: &str, param: Param) -> &mut Self {
        if let Some(ref s) = param.value {
            if !self.buffer.contains('?') {
                self.buffer.push('?');
            } else {
                self.buffer.push('&');
            }
            self.buffer.push_str(name);
            self.buffer.push('=');
            self.buffer.push_str(&urlencoding::encode(s));
        }
        
           
        self
    
    }



    pub fn build(&mut self) -> http::uri::PathAndQuery {
        use std::str::FromStr;

        http::uri::PathAndQuery::from_str(&self.buffer).expect("Building PathAndQuery")
    }
}