use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     CreatedView,
     DebtorContractView,
     DebtorContractsView,
     Guid,
    
};


impl Client {
    
    

/// Cancels a debtor contract with the given id and generate an invoice with remaining amount
/// - **id**: Contract public id
pub async fn debtor_contracts_cancel_a_debtor_contract(&self,id: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtorcontracts"))
        .url(Param::value("canceldebtorcontract"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Creates a debtor contract. CreditorPublicId is required and specifies under which creditor it shall be created since creditors don't share data.
pub async fn debtor_contracts_create_a_debtor_contract(&self,body: DebtorContractView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtorcontracts"))
        .url(Param::value("debtorcontract"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Deletes a debtor contract with the given id
/// - **id**: Contract public id
pub async fn debtor_contracts_delete_a_debtor_contract(&self,id: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtorcontracts"))
        .url(Param::value("debtorcontract"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Get all debtor contracts for a creditor
/// - **id**: Creditor public id
pub async fn debtor_contracts_get_all_debtor_contracts(&self,id: Guid,
                         
) -> Result<DebtorContractsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtorcontracts"))
        .url(Param::value("debtorcontracts"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Returns the debtor contracts of a debtor.
/// - **id**: Debtor public id
pub async fn debtor_contracts_get_all_debtor_contracts_by_debtor_public_id(&self,id: Guid,
                         
) -> Result<DebtorContractsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtorcontracts"))
        .url(Param::value("debtorcontractsbydebtorpublicid"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get debtor contract
/// - **id**: contract public id
pub async fn debtor_contracts_get_specific_debtor_contract(&self,id: Guid,
                         
) -> Result<DebtorContractView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtorcontracts"))
        .url(Param::value("debtorcontract"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Send debtor contract to debtor for them to sign
/// - **id**: contract public id
pub async fn debtor_contracts_send_debtor_contract_to_debtor(&self,id: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtorcontracts"))
        .url(Param::value("sendsignturerequest"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Updates a debtor contract
pub async fn debtor_contracts_update_a_debtor_contract(&self,body: DebtorContractView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtorcontracts"))
        .url(Param::value("debtorcontract"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
}