use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     CountriesView,
     CurrenciesView,
     DebtCollectionMessagesView,
    
};


impl Client {
    
    

/// Get all debt collection messages that can be written on debt collection claim invoices.
pub async fn common_get_debt_collection_messages(&self,
) -> Result<DebtCollectionMessagesView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("common"))
        .url(Param::value("debtcollectionmesssages"))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get all supported country and corresponding country codes in Billecta API. Country codes are according to ISO 3366-1 alpha-2 (example: "SE").
pub async fn common_get_supported_countries(&self,
) -> Result<CountriesView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("common"))
        .url(Param::value("countries"))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// All currencies supported by Billecta are defines in the following call. Billecta defines amounts in cents with each currency. Number of cent-numbers/decimals for each currency is defines in the returned objects. Please refer to Amounts section in 
pub async fn common_get_supported_currencies(&self,
) -> Result<CurrenciesView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("common"))
        .url(Param::value("currencies"))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
}