use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     BankIdAuthenticationStatusView,
     BankIdSignRequestView,
     BankIdSignStatusView,
     Guid,
     SecureTokenView,
    
};


impl Client {
    
    

/// Note that this feature requires a valid BankID certificate in order to respond properly in a production environment. For more information see 
/// - **id**: Creditor public id
/// - **ssn**: Personnumber/Swedish social security number
pub async fn authentication_create_mobile_bank_id_authentication_request(&self,id: Guid,
                         ssn: Option<String>,
                         
) -> Result<BankIdAuthenticationStatusView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("bankid"))
        .url(Param::value("authentication"))
        .url(Param::value(id))
        .query("ssn", Param::opt(ssn))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Note that this feature requires a valid BankID certificate in order to respond properly in a production environment. For more information see 
pub async fn authentication_create_mobile_bank_id_sign_request(&self,body: BankIdSignRequestView,
                         
) -> Result<BankIdSignStatusView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("bankid"))
        .url(Param::value("sign"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Creates a new SecureToken for the authenticated user and invalidates the old one, since only one SecureToken can be active per user.
/// - **id**: UserPublicId to update for
pub async fn authentication_create_a_new_secure_token(&self,id: Option<Guid>,
                         
) -> Result<SecureTokenView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("authentication"))
        .url(Param::value("securetoken"))
        .url(Param::opt(id))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Deletes the SecureToken for the authenticated user and disabled the possibility to sign in with SecureToken. To reactivate sign in with SecureToken, create a new SecureToken using the POST request.
pub async fn authentication_delete_current_secure_token(&self,
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("authentication"))
        .url(Param::value("apiauthenticate"))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Note that this feature requires a valid BankID certificate in order to respond properly in a production environment. For more information see 
/// - **id**: BankID reference token - reveived from creating request
pub async fn authentication_get_mobile_bank_id_authentication_status(&self,id: String,
                         
) -> Result<BankIdAuthenticationStatusView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("bankid"))
        .url(Param::value("authentication"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Note that this feature requires a valid BankID certificate in order to respond properly in a production environment. For more information see 
/// - **id**: BankID reference token - received from creating request
pub async fn authentication_get_mobile_bank_id_sign_status(&self,id: Guid,
                         
) -> Result<BankIdSignStatusView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("bankid"))
        .url(Param::value("sign"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Gets the current SecureToken for the authenticated user.
pub async fn authentication_get_current_secure_token(&self,
) -> Result<SecureTokenView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("authentication"))
        .url(Param::value("securetoken"))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
}