use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     CreatedView,
     Guid,
     ProjectView,
     ProjectsView,
    
};


impl Client {
    
    

/// Creates a project. CreditorPublicId is required and specifies under which creditor it shall be created since creditors don't share data
pub async fn projects_create_a_project(&self,body: ProjectView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("projects"))
        .url(Param::value("project"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Imports multiple projects. Projects will be match on ProjectNumber for updates or create
pub async fn projects_create_multiple_projects(&self,body: ProjectsView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("projects"))
        .url(Param::value("projects"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// A project can't be deleted if it used in an invoice (of any kind)
/// - **id**: Creditor public id
/// - **projectnumber**: Project number
pub async fn projects_delete_a_project(&self,id: Guid,
                         projectnumber: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("projects"))
        .url(Param::value("project"))
        .url(Param::value(id))
        .query("projectnumber", Param::value(projectnumber))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Returns the project the associated project number
/// - **id**: Creditor public id
/// - **projectnumber**: Project number
pub async fn projects_get_a_project(&self,id: Guid,
                         projectnumber: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("projects"))
        .url(Param::value("project"))
        .url(Param::value(id))
        .query("projectnumber", Param::value(projectnumber))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Get all projects for a creditor
/// - **id**: Creditor public id
pub async fn projects_get_all_projects(&self,id: Guid,
                         
) -> Result<ProjectsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("projects"))
        .url(Param::value("projects"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// 
pub async fn projects_update_a_project(&self,body: ProjectView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("projects"))
        .url(Param::value("project"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
}