use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     Guid,
     UserSubscribedInvoicesView,
    
};


impl Client {
    
    

/// Get all subscribed invoices on a specific user
/// - **userpublicid**: User public id
pub async fn notifications_get_all_subscribed_invoices(&self,userpublicid: Guid,
                         
) -> Result<UserSubscribedInvoicesView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("notifications"))
        .url(Param::value("invoicesubscription"))
        .query("userpublicid", Param::value(userpublicid))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Removing a subscribing on an invoice means that you no longer will receive updates by email on the saved user email, each time a change is made on the invoice.
/// - **userpublicid**: User public id
/// - **actionpublicid**: Action public id
pub async fn notifications_remove_subscription_on_an_invoice(&self,userpublicid: Guid,
                         actionpublicid: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("notifications"))
        .url(Param::value("invoicesubscription"))
        .query("userpublicid", Param::value(userpublicid))
        .query("actionpublicid", Param::value(actionpublicid))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Subscribing to an invoice means that you'll receive updates by email on the saved user email, each time a change is made on the invoice.
/// - **userpublicid**: User public id
/// - **actionpublicid**: Action public id
pub async fn notifications_subscribe_on_an_invoice(&self,userpublicid: Guid,
                         actionpublicid: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("notifications"))
        .url(Param::value("invoicesubscription"))
        .query("userpublicid", Param::value(userpublicid))
        .query("actionpublicid", Param::value(actionpublicid))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
}