
use crate::models::DateTime; 
use crate::models::Guid; 
use crate::models::LanguageTypeView; 
use crate::models::UserRightView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct UserView {
    
    #[serde(rename = "ActiveCreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub active_creditor_public_id: Option<Guid>,
    
    #[serde(rename = "CanManageCreditors", skip_serializing_if = "Option::is_none")]
    pub can_manage_creditors: Option<bool>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "Email", skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    
    #[serde(rename = "FullName", skip_serializing_if = "Option::is_none")]
    pub full_name: Option<String>,
    
    #[serde(rename = "HasAcceptedAgreements", skip_serializing_if = "Option::is_none")]
    pub has_accepted_agreements: Option<bool>,
    
    #[serde(rename = "HideLookupDialog", skip_serializing_if = "Option::is_none")]
    pub hide_lookup_dialog: Option<bool>,
    
    #[serde(rename = "HideSelectCreditorDialog", skip_serializing_if = "Option::is_none")]
    pub hide_select_creditor_dialog: Option<bool>,
    
    #[serde(rename = "HideSystemUpdates", skip_serializing_if = "Option::is_none")]
    pub hide_system_updates: Option<bool>,
    
    #[serde(rename = "IsAdministrator", skip_serializing_if = "Option::is_none")]
    pub is_administrator: Option<bool>,
    
    #[serde(rename = "IsApiUser", skip_serializing_if = "Option::is_none")]
    pub is_api_user: Option<bool>,
    
    #[serde(rename = "IsEnabled", skip_serializing_if = "Option::is_none")]
    pub is_enabled: Option<bool>,
    
    #[serde(rename = "Language", skip_serializing_if = "Option::is_none")]
    pub language: Option<LanguageTypeView>,
    
    #[serde(rename = "LastLogin", skip_serializing_if = "Option::is_none")]
    pub last_login: Option<DateTime>,
    
    #[serde(rename = "Password", skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    
    #[serde(rename = "PasswordExpired", skip_serializing_if = "Option::is_none")]
    pub password_expired: Option<bool>,
    
    #[serde(rename = "PasswordNeverExpires", skip_serializing_if = "Option::is_none")]
    pub password_never_expires: Option<bool>,
    
    #[serde(rename = "ReceiveSystemUpdateNotification", skip_serializing_if = "Option::is_none")]
    pub receive_system_update_notification: Option<bool>,
    
    #[serde(rename = "Rights", skip_serializing_if = "Vec::is_empty", default)]
    pub rights: Vec<UserRightView>,
    
    #[serde(rename = "UserPublicId", skip_serializing_if = "Option::is_none")]
    pub user_public_id: Option<Guid>,
    
    #[serde(rename = "Username", skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    
}