
use crate::models::ActionTypeView; 
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::DeliveryStatusTypeView; 
use crate::models::FileView; 
use crate::models::Guid; 
use crate::models::SelfInvoiceActionStageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct SelfInvoiceActionSubView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "ActionType", skip_serializing_if = "Option::is_none")]
    pub action_type: Option<ActionTypeView>,
    
    #[serde(rename = "AttestedDate", skip_serializing_if = "Option::is_none")]
    pub attested_date: Option<DateTime>,
    
    #[serde(rename = "BankgiroNo", skip_serializing_if = "Option::is_none")]
    pub bankgiro_no: Option<String>,
    
    #[serde(rename = "ClosedDate", skip_serializing_if = "Option::is_none")]
    pub closed_date: Option<DateTime>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "CreditorName", skip_serializing_if = "Option::is_none")]
    pub creditor_name: Option<String>,
    
    #[serde(rename = "CreditorOrgNo", skip_serializing_if = "Option::is_none")]
    pub creditor_org_no: Option<String>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "CurrentAmount", skip_serializing_if = "Option::is_none")]
    pub current_amount: Option<AmountView>,
    
    #[serde(rename = "DebtorName", skip_serializing_if = "Option::is_none")]
    pub debtor_name: Option<String>,
    
    #[serde(rename = "DebtorOrgNo", skip_serializing_if = "Option::is_none")]
    pub debtor_org_no: Option<String>,
    
    #[serde(rename = "DebtorPublicId", skip_serializing_if = "Option::is_none")]
    pub debtor_public_id: Option<Guid>,
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "DeliveryStatus", skip_serializing_if = "Option::is_none")]
    pub delivery_status: Option<DeliveryStatusTypeView>,
    
    #[serde(rename = "DueDate", skip_serializing_if = "Option::is_none")]
    pub due_date: Option<DateTime>,
    
    #[serde(rename = "File", skip_serializing_if = "Option::is_none")]
    pub file: Option<FileView>,
    
    #[serde(rename = "InvoiceDate", skip_serializing_if = "Option::is_none")]
    pub invoice_date: Option<DateTime>,
    
    #[serde(rename = "InvoiceNumber", skip_serializing_if = "Option::is_none")]
    pub invoice_number: Option<String>,
    
    #[serde(rename = "InvoiceSentDate", skip_serializing_if = "Option::is_none")]
    pub invoice_sent_date: Option<DateTime>,
    
    #[serde(rename = "InvoicedAmount", skip_serializing_if = "Option::is_none")]
    pub invoiced_amount: Option<AmountView>,
    
    #[serde(rename = "IsCommented", skip_serializing_if = "Option::is_none")]
    pub is_commented: Option<bool>,
    
    #[serde(rename = "IsPaused", skip_serializing_if = "Option::is_none")]
    pub is_paused: Option<bool>,
    
    #[serde(rename = "NextEvent", skip_serializing_if = "Option::is_none")]
    pub next_event: Option<String>,
    
    #[serde(rename = "NextEventDate", skip_serializing_if = "Option::is_none")]
    pub next_event_date: Option<DateTime>,
    
    #[serde(rename = "NextPaymentAmount", skip_serializing_if = "Option::is_none")]
    pub next_payment_amount: Option<AmountView>,
    
    #[serde(rename = "NextPaymentDate", skip_serializing_if = "Option::is_none")]
    pub next_payment_date: Option<DateTime>,
    
    #[serde(rename = "OCR", skip_serializing_if = "Option::is_none")]
    pub ocr: Option<String>,
    
    #[serde(rename = "Stage", skip_serializing_if = "Option::is_none")]
    pub stage: Option<SelfInvoiceActionStageTypeView>,
    
    #[serde(rename = "TotalVATAmount", skip_serializing_if = "Option::is_none")]
    pub total_vat_amount: Option<AmountView>,
    
}