
use crate::models::AmountView; 
use crate::models::DiscountTypeView; 
use crate::models::Guid; 
use crate::models::RecordTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct SelfInvoiceActionRecordView {
    
    #[serde(rename = "ArticleDescription", skip_serializing_if = "Option::is_none")]
    pub article_description: Option<String>,
    
    #[serde(rename = "ArticleNumber", skip_serializing_if = "Option::is_none")]
    pub article_number: Option<String>,
    
    #[serde(rename = "CostCenter", skip_serializing_if = "Option::is_none")]
    pub cost_center: Option<String>,
    
    #[serde(rename = "DiscountAmount", skip_serializing_if = "Option::is_none")]
    pub discount_amount: Option<AmountView>,
    
    #[serde(rename = "DiscountPercentage", skip_serializing_if = "Option::is_none")]
    pub discount_percentage: Option<f64>,
    
    #[serde(rename = "DiscountType", skip_serializing_if = "Option::is_none")]
    pub discount_type: Option<DiscountTypeView>,
    
    #[serde(rename = "Hidden", skip_serializing_if = "Option::is_none")]
    pub hidden: Option<bool>,
    
    #[serde(rename = "ProductPublicId", skip_serializing_if = "Option::is_none")]
    pub product_public_id: Option<Guid>,
    
    #[serde(rename = "Project", skip_serializing_if = "Option::is_none")]
    pub project: Option<String>,
    
    #[serde(rename = "Quantity", skip_serializing_if = "Option::is_none")]
    pub quantity: Option<f64>,
    
    #[serde(rename = "RecordType", skip_serializing_if = "Option::is_none")]
    pub record_type: Option<RecordTypeView>,
    
    #[serde(rename = "SequenceNo", skip_serializing_if = "Option::is_none")]
    pub sequence_no: Option<i64>,
    
    #[serde(rename = "UnitPrice", skip_serializing_if = "Option::is_none")]
    pub unit_price: Option<AmountView>,
    
    #[serde(rename = "Units", skip_serializing_if = "Option::is_none")]
    pub units: Option<String>,
    
    #[serde(rename = "VAT", skip_serializing_if = "Option::is_none")]
    pub vat: Option<f64>,
    
}